/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.exceptions.CommandFactoryException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.BuildableProgram;
import com.scriptbasic.interfaces.CommandFactory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.SyntaxAnalyzer;
import com.scriptbasic.syntax.BasicProgram;

public final class BasicSyntaxAnalyzer
implements SyntaxAnalyzer {
    private final LexicalAnalyzer lexicalAnalyzer;
    private final CommandFactory commandFactory;
    private LexicalElement lexicalElement;

    public BasicSyntaxAnalyzer(LexicalAnalyzer lexicalAnalyzer, CommandFactory commandFactory) {
        this.lexicalAnalyzer = lexicalAnalyzer;
        this.commandFactory = commandFactory;
    }

    private static boolean lineToIgnore(String lexString) {
        return lexString.equals("\n") || lexString.equals("'") || lexString.equalsIgnoreCase("REM");
    }

    public LexicalElement getLexicalElement() {
        return this.lexicalElement;
    }

    public void setLexicalElement(LexicalElement lexicalElement) {
        this.lexicalElement = lexicalElement;
    }

    @Override
    public BuildableProgram analyze() throws AnalysisException {
        try {
            BasicProgram buildableProgram = new BasicProgram();
            this.lexicalElement = this.lexicalAnalyzer.peek();
            while (this.lexicalElement != null) {
                if (this.lexicalElement.isSymbol().booleanValue()) {
                    this.lexicalAnalyzer.get();
                    String lexString = this.lexicalElement.getLexeme();
                    if (BasicSyntaxAnalyzer.lineToIgnore(lexString)) {
                        this.consumeIgnoredLine(this.lexicalAnalyzer, lexString);
                    } else {
                        buildableProgram.addCommand(this.commandFactory.create(lexString));
                    }
                } else {
                    buildableProgram.addCommand(this.commandFactory.create(null));
                }
                this.lexicalElement = this.lexicalAnalyzer.peek();
            }
            buildableProgram.postprocess();
            return buildableProgram;
        }
        catch (CommandFactoryException e) {
            throw new BasicSyntaxException(e.getMessage(), this.lexicalElement, e);
        }
    }

    private void consumeIgnoredLine(LexicalAnalyzer lexicalAnalyzer, String lexString) throws AnalysisException {
        LexicalElement le;
        while (!lexString.equals("\n") && (le = lexicalAnalyzer.get()) != null) {
            lexString = le.getLexeme();
        }
    }
}

