/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility.functions;

import com.scriptbasic.api.BasicFunction;
import com.scriptbasic.classification.Math;
import com.scriptbasic.classification.Utility;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.utility.CastUtility;
import com.scriptbasic.utility.NoInstance;

public class MathFunctions {
    private MathFunctions() {
        NoInstance.isPossible();
    }

    @BasicFunction(classification={Math.class})
    public static Number abs(Number x) throws ExecutionException {
        if (x instanceof Double) {
            return java.lang.Math.abs((Double)x);
        }
        if (x instanceof Long) {
            return (Long)x > 0L ? (Number)x : (Number)(-((Long)x).longValue());
        }
        throw new BasicRuntimeException("MathFunctions.abs(Number x) was called with an argument that is neither Double, nor Long: " + x.toString() + "of type " + x.getClass().toString());
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double acos(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double asin(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double atan(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double atan2(double x, double y) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double cbrt(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double ceil(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double copySign(double magnitude, double sign) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double cos(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double cosh(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double exp(double a) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double expm1(double x) {
        return 0.0;
    }

    @BasicFunction(classification={Utility.class}, alias="float")
    public static Double floatF(Object s) {
        try {
            return (Double)CastUtility.cast(s, Double.class);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @BasicFunction(classification={Utility.class})
    public static Long integer(Object s) {
        try {
            return (Long)CastUtility.cast(s, Long.class);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double floor(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static Long getExponent(double d) {
        return java.lang.Math.getExponent(d);
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double hypot(double x, double y) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double IEEEremainder(double f1, double f2) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double log(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double log10(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double log1p(double x) {
        return 0.0;
    }

    @BasicFunction(classification={Math.class})
    public static Number max(Number a, Number b) {
        if (a instanceof Double && b instanceof Double) {
            return java.lang.Math.max((Double)a, (Double)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return java.lang.Math.max((Long)a, (Long)b);
        }
        return null;
    }

    @BasicFunction(classification={Math.class})
    public static Number min(Number a, Number b) {
        if (a instanceof Double && b instanceof Double) {
            return java.lang.Math.min((Double)a, (Double)b);
        }
        if (a instanceof Long && b instanceof Long) {
            return java.lang.Math.min((Long)a, (Long)b);
        }
        return null;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double pow(double a, double b) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double random() {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double rint(double a) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double round(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double scalb(double d, int scaleFactor) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double signum(double d) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double sin(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double sinh(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double sqrt(double a) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double tan(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double tanh(double x) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double toDegrees(double angrad) {
        return 0.0;
    }

    @BasicFunction(substituteClass=java.lang.Math.class, classification={Math.class})
    public static double toRadians(double angdeg) {
        return 0.0;
    }
}

