/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.commands;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.commands.AbstractCommand;
import com.scriptbasic.executors.commands.CommandNext;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.LeftValue;
import com.scriptbasic.spi.RightValue;
import com.scriptbasic.utility.NumberUtility;

public class CommandFor
extends AbstractCommand {
    private static final BasicLongValue ONE = new BasicLongValue(1L);
    private LeftValue loopVariable;
    private Expression loopStartValue;
    private Expression loopEndValue;
    private Expression loopStepValue;
    private CommandNext loopEndNode;
    private RightValue loopStart;
    private RightValue loopEnd;
    private RightValue loopStep;

    public void setLoopEndNode(CommandNext loopEndNode) {
        this.loopEndNode = loopEndNode;
    }

    public LeftValue getLoopVariable() {
        return this.loopVariable;
    }

    public void setLoopVariable(LeftValue loopVariable) {
        this.loopVariable = loopVariable;
    }

    public void setLoopStartValue(Expression loopStartValue) {
        this.loopStartValue = loopStartValue;
    }

    public void setLoopEndValue(Expression loopEndValue) {
        this.loopEndValue = loopEndValue;
    }

    public void setLoopStepValue(Expression loopStepValue) {
        this.loopStepValue = loopStepValue;
    }

    private void startLoopWithLong(Interpreter interpreter) throws ScriptBasicException {
        Long start = BasicLongValue.asLong(this.loopStart);
        this.loopVariable.setValue(new BasicLongValue(start), interpreter);
        this.setNextCommand(interpreter, BasicLongValue.asLong(this.loopStep), start, BasicLongValue.asLong(this.loopEnd));
    }

    private void startLoopWithDouble(Interpreter interpreter) throws ScriptBasicException {
        Double start = BasicDoubleValue.asDouble(this.loopStart);
        this.loopVariable.setValue(new BasicDoubleValue(start), interpreter);
        this.setNextCommand(interpreter, BasicDoubleValue.asDouble(this.loopStep), start, BasicDoubleValue.asDouble(this.loopEnd));
    }

    private RightValue getLoopVariableAsRightValue(Interpreter interpreter) throws ScriptBasicException {
        return interpreter.getVariables().getVariableValue(((BasicLeftValue)this.loopVariable).getIdentifier());
    }

    private void finishTheLoop(Interpreter interpreter) {
        interpreter.setNextCommand(this.loopEndNode.getNextCommand());
    }

    private <T extends Number> void setNextCommand(Interpreter interpreter, T step, T newLoopValue, T loopEndDouble) {
        if (NumberUtility.isPositive(step)) {
            if (NumberUtility.compare(newLoopValue, loopEndDouble) <= 0) {
                interpreter.setNextCommand(this.getNextCommand());
            } else {
                this.finishTheLoop(interpreter);
            }
        } else if (NumberUtility.compare(newLoopValue, loopEndDouble) >= 0) {
            interpreter.setNextCommand(this.getNextCommand());
        } else {
            this.finishTheLoop(interpreter);
        }
    }

    private void stepLoopVariable(Interpreter interpreter, Long step) throws ScriptBasicException {
        Long loopEndValue = BasicLongValue.asLong(this.loopEnd);
        RightValue rv = this.getLoopVariableAsRightValue(interpreter);
        Long oldLoopValue = BasicLongValue.asLong(rv);
        if (oldLoopValue == null) {
            throw new ScriptBasicException("FOR loop variable became undef in the loop (integer)");
        }
        long newLoopValue = oldLoopValue + step;
        this.loopVariable.setValue(new BasicLongValue(newLoopValue), interpreter);
        this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
    }

    private void stepLoopVariable(Interpreter interpreter, Double step) throws ScriptBasicException {
        Double loopEndValue = BasicDoubleValue.asDouble(this.loopEnd);
        RightValue rv = this.getLoopVariableAsRightValue(interpreter);
        Double oldLoopValue = BasicDoubleValue.asDouble(rv);
        if (oldLoopValue == null) {
            throw new ScriptBasicException("FOR loop variable became undef in the loop (float)");
        }
        double newLoopValue = oldLoopValue + step;
        this.loopVariable.setValue(new BasicDoubleValue(newLoopValue), interpreter);
        this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void stepLoopVariable(Interpreter interpreter) throws ScriptBasicException {
        if (!(this.loopVariable instanceof BasicLeftValue)) throw new BasicRuntimeException("Loop variable is not BasicLeftValue, this is probably internal error");
        if (this.loopStep instanceof BasicLongValue) {
            this.stepLoopVariable(interpreter, BasicLongValue.asLong(this.loopStep));
            return;
        } else {
            if (!(this.loopStep instanceof BasicDoubleValue)) throw new BasicRuntimeException("Loop step value can be long or double");
            this.stepLoopVariable(interpreter, BasicDoubleValue.asDouble(this.loopStep));
        }
    }

    void noStepLoopVariable(Interpreter interpreter) throws ScriptBasicException {
        if (this.loopStep instanceof BasicLongValue) {
            Long step = BasicLongValue.asLong(this.loopStep);
            Long loopEndValue = BasicLongValue.asLong(this.loopEnd);
            Long newLoopValue = BasicLongValue.asLong(this.getLoopVariableAsRightValue(interpreter));
            this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
        } else if (this.loopStep instanceof BasicDoubleValue) {
            Double step = BasicDoubleValue.asDouble(this.loopStep);
            Double loopEndValue = BasicDoubleValue.asDouble(this.loopEnd);
            Double newLoopValue = BasicDoubleValue.asDouble(this.getLoopVariableAsRightValue(interpreter));
            this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
        } else {
            throw new BasicRuntimeException("Loop step value can be long or double");
        }
    }

    private void setLoopStart(Interpreter interpreter) throws ScriptBasicException {
        if (this.loopStep instanceof BasicDoubleValue) {
            if (this.loopStart instanceof BasicDoubleValue) {
                this.loopVariable.setValue(this.loopStart, interpreter);
            } else {
                this.startLoopWithDouble(interpreter);
            }
        } else if (this.loopStep instanceof BasicLongValue) {
            if (this.loopStart instanceof BasicLongValue) {
                this.loopVariable.setValue(this.loopStart, interpreter);
            } else {
                this.startLoopWithLong(interpreter);
            }
        } else {
            throw new BasicRuntimeException("Step expression is not long or double");
        }
    }

    @Override
    public void execute(Interpreter interpreter) throws ScriptBasicException {
        this.loopStart = this.loopStartValue.evaluate(interpreter);
        this.loopEnd = this.loopEndValue.evaluate(interpreter);
        this.loopStep = this.loopStepValue != null ? this.loopStepValue.evaluate(interpreter) : ONE;
        this.setLoopStart(interpreter);
        this.noStepLoopVariable(interpreter);
    }
}

