/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.commands.CommandUse;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.spi.Command;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.KlassUtility;
import com.scriptbasic.utility.LexUtility;

public class CommandAnalyzerUse
extends AbstractCommandAnalyzer {
    public CommandAnalyzerUse(Context ctx) {
        super(ctx);
    }

    @Override
    public Command analyze() throws AnalysisException {
        Class<?> klass;
        String className = ExpressionUtility.convertToString(this.analyzeExpression());
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "from", "Keyword 'FROM' is missing in command 'USE'");
        String packageName = ExpressionUtility.convertToString(this.analyzeExpression());
        String aliasName = LexUtility.isLexeme(this.ctx.lexicalAnalyzer, "as") ? ExpressionUtility.convertToString(this.analyzeExpression()) : className;
        this.consumeEndOfLine();
        if (className.indexOf(46) != -1 || aliasName.indexOf(46) != -1) {
            throw new BasicSyntaxException("class name and alias name should not contain dot in command USE");
        }
        String fullClassName = packageName + "." + className;
        try {
            klass = KlassUtility.forNameEx(fullClassName);
        }
        catch (BasicSyntaxException e) {
            throw new BasicSyntaxException("The class in the USE statement is not found.", e);
        }
        return new CommandUse(klass, aliasName);
    }
}

