/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.expression;

import com.scriptbasic.context.Context;
import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.operators.AbstractBinaryOperator;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.syntax.AbstractAnalyzer;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public abstract class AbstractExpressionAnalyzer
extends AbstractAnalyzer<Expression>
implements ExpressionAnalyzer {
    private final Context ctx;

    protected AbstractExpressionAnalyzer(Context ctx) {
        this.ctx = ctx;
    }

    protected abstract Integer getMaximumPriority();

    protected abstract Map<String, Class<? extends AbstractBinaryOperator>> getOperatorMap(Integer var1);

    @Override
    public Expression analyze() throws AnalysisException {
        return this.analyze(this.getMaximumPriority());
    }

    private LexicalElement peekAtOperatorLexeme() throws AnalysisException {
        return this.ctx.lexicalAnalyzer.peek();
    }

    private void consumeTheOperatorLexeme() throws AnalysisException {
        this.ctx.lexicalAnalyzer.get();
    }

    private boolean isOperatorWithPriority(LexicalElement le, Integer priority) {
        return le != null && le.isSymbol() != false && this.getOperatorMap(priority).containsKey(le.getLexeme());
    }

    private Class<? extends AbstractBinaryOperator> getOperatorClass(LexicalElement le, Integer priority) {
        return this.getOperatorMap(priority).get(le.getLexeme());
    }

    private AbstractBinaryOperator getOperator(LexicalElement le, Integer priority) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.getOperatorClass(le, priority).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Expression analyzeWithPositivePriority(Integer priority) throws AnalysisException {
        Expression expression;
        Expression leftOperand = this.analyze(priority - 1);
        try {
            LexicalElement le;
            while (this.isOperatorWithPriority(le = this.peekAtOperatorLexeme(), priority)) {
                this.consumeTheOperatorLexeme();
                Expression rightOperand = this.analyze(priority - 1);
                AbstractBinaryOperator operator = this.getOperator(le, priority);
                operator.setLeftOperand(leftOperand);
                operator.setRightOperand(rightOperand);
                leftOperand = operator;
            }
            expression = leftOperand;
        }
        catch (AnalysisException e) {
            throw new BasicSyntaxException(e);
        }
        catch (Exception e) {
            throw new BasicInterpreterInternalError("Can not instantiate the operator class", e);
        }
        return expression;
    }

    private Expression analyze(Integer priority) throws AnalysisException {
        if (priority == 0) {
            return this.ctx.tagAnalyzer.analyze();
        }
        return this.analyzeWithPositivePriority(priority);
    }
}

