package com.scriptbasic.executors.commands;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.LeftValue;

public class CommandLet extends AbstractCommand {
    private LeftValue leftValue;
    private Expression expression;

    public void setLeftValue(final LeftValue leftValue) {
        this.leftValue = leftValue;
    }

    public void setExpression(final Expression expression) {
        this.expression = expression;
    }

    @Override
    public void execute(final Interpreter interpreter) throws ScriptBasicException {
        try {
            final var rv = expression.evaluate(interpreter);
            if (resultHasToBeStored()) {
                leftValue.setValue(rv, interpreter);
            }
        } catch (final Exception e) {
            throw new BasicRuntimeException(e);
        }
    }

    /**
     * When there is no left value it means that we evaluate the expression but we do not store
     * the result. It happens when a bare 'object.method()' is the command line and the result is
     * not stored in any BASIC variable. Such a line is compiled by the CALL analyzer.
     *
     * @return true if we can store the result in a left value
     */
    private boolean resultHasToBeStored() {
        return leftValue != null;
    }

}
