/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.operators;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.AbstractIdentifieredExpression;
import com.scriptbasic.executors.operators.AbstractBinaryOperator;
import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.executors.rightvalues.ArrayElementAccess;
import com.scriptbasic.executors.rightvalues.FunctionCall;
import com.scriptbasic.executors.rightvalues.VariableAccess;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.RightValue;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.KlassUtility;
import com.scriptbasic.utility.ReflectionUtility;
import com.scriptbasic.utility.RightValueUtility;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class JavaObjectFieldAccessOperator
extends AbstractBinaryOperator {
    private static Class<?>[] getClassArray(List<RightValue> args) {
        ArrayList result = new ArrayList();
        if (args != null) {
            for (RightValue arg : args) {
                result.add(RightValueUtility.getValueObject(arg).getClass());
            }
        }
        return result.isEmpty() ? new Class[]{} : result.toArray(new Class[0]);
    }

    private static Object getArrayElement(Object[] array, Integer index) throws ScriptBasicException {
        if (index < 0) {
            throw new BasicRuntimeException("Can not use " + index + " < 0 as array index");
        }
        if (index >= array.length) {
            throw new BasicRuntimeException("Cannot use index" + index + " > max index" + (array.length - 1) + " ");
        }
        return array[index];
    }

    private Object fetchFieldObject(Interpreter interpreter) throws ScriptBasicException {
        Object object = this.getLeftOperandObject(interpreter);
        AbstractIdentifieredExpression rightOp = (AbstractIdentifieredExpression)this.getRightOperand();
        String fieldName = rightOp.getVariableName();
        return KlassUtility.getField(object, fieldName);
    }

    private RightValue fetchField(Interpreter interpreter) throws ScriptBasicException {
        Object fieldObject = this.fetchFieldObject(interpreter);
        return RightValueUtility.createRightValue(fieldObject);
    }

    private RightValue callMethod(Interpreter interpreter, Object object, Class<?> klass) throws ScriptBasicException {
        FunctionCall rightOp = (FunctionCall)this.getRightOperand();
        String methodName = rightOp.getVariableName();
        ExpressionList expressionList = rightOp.getExpressionList();
        List<RightValue> args = ExpressionUtility.evaluateExpressionList(interpreter, expressionList);
        Class<?> calculatedKlass = klass == null ? object.getClass() : klass;
        Method method = interpreter.getJavaMethod(calculatedKlass, methodName);
        if (method == null) {
            try {
                method = this.findAppropriateMethod(calculatedKlass, methodName, args);
            }
            catch (NoSuchMethodException e) {
                throw new BasicRuntimeException("Method '" + methodName + "' from class '" + klass + "' can not be accessed", e);
            }
        }
        return RightValueUtility.createRightValue(ReflectionUtility.invoke(interpreter, methodName, method, object, args));
    }

    private Method findAppropriateMethod(Class<?> klass, String methodName, List<RightValue> args) throws BasicRuntimeException, NoSuchMethodException {
        Class[] argClasses = JavaObjectFieldAccessOperator.getClassArray(args);
        List methods = Arrays.stream(klass.getMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> method.getParameterTypes().length >= argClasses.length).filter(method -> IntStream.range(0, method.getParameterTypes().length - 1).noneMatch(i -> i < argClasses.length ? !method.getParameterTypes()[i].isAssignableFrom(argClasses[i]) : method.getParameterTypes()[i].isPrimitive())).collect(Collectors.toList());
        if (methods.size() > 1) {
            return klass.getMethod(methodName, argClasses);
        }
        if (methods.size() == 0) {
            throw new BasicRuntimeException("There is no matching method for '" + methodName + "' in class '" + klass.getName() + "'");
        }
        return (Method)methods.get(0);
    }

    private Object getLeftOperandObject(Interpreter interpreter) throws ScriptBasicException {
        RightValue leftOp = this.getLeftOperand().evaluate(interpreter);
        if (!(leftOp instanceof AbstractPrimitiveRightValue)) {
            throw new BasicRuntimeException("Can not get field access from " + (Serializable)(leftOp == null ? "null" : leftOp.getClass()) + " from variable " + ((VariableAccess)this.getLeftOperand()).getVariableName());
        }
        return ((AbstractPrimitiveRightValue)leftOp).getValue();
    }

    private Class<?> getStaticClass(Interpreter interpreter) {
        Class<?> result = null;
        if (this.getLeftOperand() instanceof VariableAccess) {
            String classAsName = ((VariableAccess)this.getLeftOperand()).getVariableName();
            if (interpreter.getUseMap().containsKey(classAsName)) {
                result = interpreter.getUseMap().get(classAsName);
            }
        }
        return result;
    }

    @Override
    public RightValue evaluate(Interpreter interpreter) throws ScriptBasicException {
        RightValue result;
        Expression rightOp = this.getRightOperand();
        if (rightOp instanceof VariableAccess) {
            result = this.fetchField(interpreter);
        } else if (rightOp instanceof FunctionCall) {
            Class<?> klass = this.getStaticClass(interpreter);
            Object object = null;
            if (klass == null) {
                object = this.getLeftOperandObject(interpreter);
            }
            result = this.callMethod(interpreter, object, klass);
        } else if (rightOp instanceof ArrayElementAccess) {
            Object variable = this.fetchFieldObject(interpreter);
            for (Expression expression : ((ArrayElementAccess)rightOp).getExpressionList()) {
                if (variable instanceof Object[]) {
                    Integer index = RightValueUtility.convert2Integer(expression.evaluate(interpreter));
                    variable = JavaObjectFieldAccessOperator.getArrayElement((Object[])variable, index);
                    continue;
                }
                throw new BasicRuntimeException("Java object field is not array, can not access it that way.");
            }
            result = RightValueUtility.createRightValue(variable);
        } else {
            throw new BasicRuntimeException("Field access operator is not implemented to handle variable field.");
        }
        return result;
    }
}

