/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.script;

import com.scriptbasic.api.Configuration;
import com.scriptbasic.api.Version;
import com.scriptbasic.configuration.BasicConfiguration;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.script.ScriptEngine;
import java.util.List;
import java.util.function.Consumer;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;

public class ScriptBasicEngineFactory
implements ScriptEngineFactory {
    private static final Logger LOG = LoggerFactory.getLogger();
    public final Configuration config;
    private Bindings globalScopeBinding;
    private String engineName = "ScriptBasic";
    private String version = "2.1.0";
    private List<String> extensions = Version.extensions;
    private List<String> mimeTypes = Version.mimeTypes;
    private List<String> names = Version.names;
    private String language = "scriptbasic";
    private String languageVersion = "5.0j";

    public ScriptBasicEngineFactory() {
        this(new BasicConfiguration());
    }

    public ScriptBasicEngineFactory(Configuration config) {
        this.config = config;
        this.engineName = config.getConfigValue("engineName").orElse(this.engineName);
        this.version = config.getConfigValue("version").orElse(this.version);
        this.language = config.getConfigValue("language").orElse(this.language);
        this.languageVersion = config.getConfigValue("languageVersion").orElse(this.languageVersion);
        this.loadKeys("extension", x -> {
            this.extensions = x;
        });
        this.loadKeys("mimeType", x -> {
            this.mimeTypes = x;
        });
        this.loadKeys("name", x -> {
            this.names = x;
        });
    }

    public Bindings getGlobalScopeBinding() {
        return this.globalScopeBinding;
    }

    public void setGlobalScopeBinding(Bindings globalScopeBinding) {
        this.globalScopeBinding = globalScopeBinding;
    }

    private void loadKeys(String key, Consumer<List<String>> setter) {
        List<String> list;
        if (this.config != null && !(list = this.config.getConfigValueList(key)).isEmpty()) {
            setter.accept(list);
        }
    }

    @Override
    public String getEngineName() {
        return this.engineName;
    }

    @Override
    public String getEngineVersion() {
        return this.version;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getLanguageName() {
        return this.language;
    }

    @Override
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getNames();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "STATELESS";
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        String sep = "";
        Object argsS = "";
        for (String arg : args) {
            argsS = sep + arg;
            sep = ",";
        }
        return String.format("%s.%s(%s)", obj, m, argsS);
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return String.format("print \"%s\"", toDisplay);
    }

    @Override
    public String getProgram(String ... statements) {
        int len = 0;
        for (String line : statements) {
            len += 1 + line.length();
        }
        StringBuilder sb = new StringBuilder(len);
        for (String line : statements) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    @Override
    public javax.script.ScriptEngine getScriptEngine() {
        return new ScriptEngine(this);
    }
}

