/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BuildableProgram;
import com.scriptbasic.interfaces.CommandFactory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.NestedStructureHouseKeeper;
import com.scriptbasic.interfaces.SyntaxAnalyzer;
import com.scriptbasic.spi.Command;
import com.scriptbasic.syntax.BasicProgram;
import java.util.ArrayList;
import java.util.List;

public final class BasicSyntaxAnalyzer
implements SyntaxAnalyzer {
    private final LexicalAnalyzer lexicalAnalyzer;
    private final CommandFactory commandFactory;
    private final NestedStructureHouseKeeper nestedStructureHouseKeeper;
    private LexicalElement lexicalElement;
    private List<Command> additionalCommands;

    public BasicSyntaxAnalyzer(LexicalAnalyzer lexicalAnalyzer, CommandFactory commandFactory, NestedStructureHouseKeeper nestedStructureHouseKeeper) {
        this.lexicalAnalyzer = lexicalAnalyzer;
        this.commandFactory = commandFactory;
        this.nestedStructureHouseKeeper = nestedStructureHouseKeeper;
    }

    public static boolean lineToIgnore(String lexString) {
        return lexString.equals("\n") || lexString.equals("'") || lexString.equalsIgnoreCase("rem");
    }

    public LexicalElement getLexicalElement() {
        return this.lexicalElement;
    }

    public void setLexicalElement(LexicalElement lexicalElement) {
        this.lexicalElement = lexicalElement;
    }

    @Override
    public BuildableProgram analyze() throws AnalysisException {
        BasicProgram buildableProgram = new BasicProgram();
        this.lexicalElement = this.lexicalAnalyzer.peek();
        while (this.lexicalElement != null) {
            if (this.lexicalElement.isSymbol().booleanValue()) {
                this.lexicalAnalyzer.get();
                String lexString = this.lexicalElement.getLexeme();
                if (BasicSyntaxAnalyzer.lineToIgnore(lexString)) {
                    BasicSyntaxAnalyzer.consumeIgnoredLine(this.lexicalAnalyzer, lexString);
                } else {
                    Command newCommand = this.commandFactory.create(lexString);
                    if (newCommand != null) {
                        buildableProgram.addCommand(newCommand);
                    }
                }
            } else {
                Command newCommand = this.commandFactory.create(null);
                if (newCommand != null) {
                    buildableProgram.addCommand(newCommand);
                }
            }
            if (this.additionalCommands != null) {
                this.additionalCommands.forEach(buildableProgram::addCommand);
                this.additionalCommands = null;
            }
            this.lexicalElement = this.lexicalAnalyzer.peek();
        }
        this.nestedStructureHouseKeeper.checkFinalState();
        buildableProgram.postprocess();
        return buildableProgram;
    }

    @Override
    public void addCommand(Command command) {
        if (this.additionalCommands == null) {
            this.additionalCommands = new ArrayList<Command>();
        }
        this.additionalCommands.add(command);
    }

    public static void consumeIgnoredLine(LexicalAnalyzer lexicalAnalyzer, String lexString) throws AnalysisException {
        LexicalElement le;
        while (!lexString.equals("\n") && (le = lexicalAnalyzer.get()) != null) {
            lexString = le.getLexeme();
        }
    }
}

