/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.NoAccess;
import com.scriptbasic.spi.NoAccessProxy;
import com.scriptbasic.spi.RightValue;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.NoInstance;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectionUtility {
    private ReflectionUtility() {
        NoInstance.isPossible();
    }

    public static Object invoke(Interpreter interpreter, String symbolicName, Method method, Object object, List<RightValue> args) throws ScriptBasicException {
        Object javaCallResult;
        ReflectionUtility.assertNoAccess(symbolicName, object);
        interpreter.getHook().beforeCallJavaFunction(method);
        try {
            Object[] argArray = ExpressionUtility.getObjectArray(args, method, interpreter);
            javaCallResult = method.invoke(object, argArray);
            ReflectionUtility.setTheInterpreterIfTheResultIsBasicArray(javaCallResult, interpreter);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtility.exceptionFrom(e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new BasicRuntimeException("Can not invoke method " + symbolicName, e);
        }
        catch (Exception e) {
            throw new BasicRuntimeException("Invoking method '" + symbolicName + "' throws exception:", e);
        }
        return interpreter.getHook().afterCallJavaFunction(method, javaCallResult);
    }

    private static ScriptBasicException exceptionFrom(InvocationTargetException e) {
        if (e.getTargetException() instanceof ScriptBasicException) {
            return (ScriptBasicException)e.getTargetException();
        }
        return new ScriptBasicException(e.getTargetException());
    }

    private static void assertNoAccess(String symbolicName, Object object) throws BasicRuntimeException {
        if (object instanceof NoAccess) {
            Object target = object instanceof NoAccessProxy ? ((NoAccessProxy)object).target : object;
            throw new BasicRuntimeException("It is not allowed to call  '" + symbolicName + "' on object of class '" + target.getClass().getName());
        }
    }

    private static void setTheInterpreterIfTheResultIsBasicArray(Object javaCallResult, Interpreter interpreter) {
        if (javaCallResult instanceof BasicArrayValue) {
            ((BasicArrayValue)javaCallResult).setInterpreter(interpreter);
        }
    }
}

