/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.operators;

import com.scriptbasic.executors.operators.AbstractBinaryFullCircuitOperator;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.executors.rightvalues.BasicEmptyValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.BasicValue;
import com.scriptbasic.spi.RightValue;

public abstract class AbstractCompareOperator
extends AbstractBinaryFullCircuitOperator {
    protected abstract boolean decide(int var1);

    protected <T> Boolean compareTo(Comparable<T> l, T r) throws BasicRuntimeException {
        int comparisonResult = l.compareTo(r);
        return this.decide(comparisonResult);
    }

    @Override
    protected RightValue evaluateOn(RightValue leftOperand, RightValue rightOperand) throws BasicRuntimeException {
        Object rightValue;
        Object leftValue;
        if (leftOperand == null && rightOperand == null) {
            return BasicValue.TRUE;
        }
        if (leftOperand == null || rightOperand == null) {
            return BasicValue.FALSE;
        }
        if (leftOperand.isLong().booleanValue() || rightOperand.isLong().booleanValue()) {
            leftValue = AbstractCompareOperator.getAsLong(leftOperand);
            rightValue = AbstractCompareOperator.getAsLong(rightOperand);
            if (leftValue != null && rightValue != null) {
                return new BasicBooleanValue(this.compareTo((Comparable)leftValue, (Object)rightValue));
            }
        }
        if (leftOperand.isLong().booleanValue() || rightOperand.isLong().booleanValue() || leftOperand.isDouble().booleanValue() || rightOperand.isDouble().booleanValue()) {
            leftValue = AbstractCompareOperator.getAsDouble(leftOperand);
            rightValue = AbstractCompareOperator.getAsDouble(rightOperand);
            if (leftValue != null && rightValue != null) {
                return new BasicBooleanValue(this.compareTo((Comparable)leftValue, (Object)rightValue));
            }
        }
        if (leftOperand.isBoolean().booleanValue() && rightOperand.isBoolean().booleanValue()) {
            leftValue = AbstractCompareOperator.getAsBoolean(leftOperand);
            rightValue = AbstractCompareOperator.getAsBoolean(rightOperand);
            if (leftValue != null && rightValue != null) {
                return new BasicBooleanValue(this.compareTo((Comparable)leftValue, (Object)rightValue));
            }
        }
        if (leftOperand.isString().booleanValue() || rightOperand.isString().booleanValue()) {
            leftValue = AbstractCompareOperator.getAsString(leftOperand);
            rightValue = AbstractCompareOperator.getAsString(rightOperand);
            if (leftValue != null && rightValue != null) {
                return new BasicBooleanValue(this.compareTo((Comparable)leftValue, (Object)rightValue));
            }
        }
        if (leftOperand.isJavaObject().booleanValue() || rightOperand.isJavaObject().booleanValue()) {
            leftValue = AbstractCompareOperator.getAsObject(leftOperand);
            rightValue = AbstractCompareOperator.getAsObject(rightOperand);
            if (leftValue != null && rightValue != null && leftValue instanceof Comparable && rightValue instanceof Comparable) {
                Comparable a = (Comparable)leftValue;
                Comparable b = (Comparable)rightValue;
                return new BasicBooleanValue(this.compareTo(a, b));
            }
        }
        if (leftOperand == BasicEmptyValue.EMPTY_VALUE && rightOperand == BasicEmptyValue.EMPTY_VALUE) {
            return new BasicBooleanValue(this.compareTo(BasicEmptyValue.EMPTY_VALUE.getNumericValue(), BasicEmptyValue.EMPTY_VALUE.getNumericValue()));
        }
        throw new BasicRuntimeException("Type mismatch, left operand: " + leftOperand + ", right operand: " + rightOperand);
    }
}

