/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.executors.rightvalues.BasicEmptyValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.RightValue;

public class BasicStringValue
extends AbstractPrimitiveRightValue<String> {
    public BasicStringValue(String s) {
        this.setValue(s);
    }

    public static String asString(RightValue rv) throws BasicRuntimeException {
        try {
            String resultString;
            if (rv == BasicEmptyValue.EMPTY_VALUE) {
                return "";
            }
            if (rv == null || ((AbstractPrimitiveRightValue)rv).getValue() == null) {
                resultString = "undef";
            } else if (rv.isString().booleanValue() || rv.isNumeric().booleanValue() || rv.isBoolean().booleanValue() || rv.isJavaObject().booleanValue()) {
                resultString = ((AbstractPrimitiveRightValue)rv).getValue().toString();
            } else {
                throw new BasicRuntimeException("Can not convert value to string");
            }
            return resultString;
        }
        catch (ClassCastException cce) {
            throw new BasicRuntimeException("Error converting to string", cce);
        }
    }

    public String toString() {
        try {
            return BasicStringValue.asString(this);
        }
        catch (BasicRuntimeException e) {
            return super.toString();
        }
    }
}

