/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.leftvalues;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.leftvalues.ArrayElementAccessLeftValueModifier;
import com.scriptbasic.executors.leftvalues.LeftValueModifier;
import com.scriptbasic.executors.leftvalues.ObjectFieldAccessLeftValueModifier;
import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.HierarchicalVariableMap;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.spi.BasicArray;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.LeftValue;
import com.scriptbasic.spi.RightValue;
import com.scriptbasic.utility.KlassUtility;
import com.scriptbasic.utility.RightValueUtility;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BasicLeftValue
implements LeftValue {
    private static final Logger LOG = LoggerFactory.getLogger();
    private final List<LeftValueModifier> modifiers = new LinkedList<LeftValueModifier>();
    private String identifier;

    private static RightValue handleAccessModifier(RightValue variable, LeftValueModifier modifier, boolean hasNext, RightValue rightValue, Interpreter interpreter) throws ScriptBasicException {
        if (modifier instanceof ArrayElementAccessLeftValueModifier) {
            variable = BasicLeftValue.handleArrayElementAccess(variable, (ArrayElementAccessLeftValueModifier)modifier, hasNext, rightValue, interpreter);
        } else if (modifier instanceof ObjectFieldAccessLeftValueModifier) {
            variable = BasicLeftValue.handleObjectFieldAccess(variable, (ObjectFieldAccessLeftValueModifier)modifier, hasNext, rightValue);
        }
        return variable;
    }

    private static RightValue handleObjectFieldAccess(RightValue variable, ObjectFieldAccessLeftValueModifier modifier, boolean hasNext, RightValue rightValue) throws ScriptBasicException {
        String fieldName = modifier.getFieldName();
        if (!(variable instanceof BasicJavaObjectValue)) {
            throw new BasicRuntimeException(String.valueOf(variable) + " is not an object, can not access its field '" + fieldName + "'");
        }
        BasicJavaObjectValue bjov = (BasicJavaObjectValue)variable;
        Object object = bjov.getValue();
        if (hasNext) {
            Object fieldObject = KlassUtility.getField(object, fieldName);
            return RightValueUtility.createRightValue(fieldObject);
        }
        Object valueObject = RightValueUtility.getValueObject(rightValue);
        KlassUtility.setField(object, fieldName, valueObject);
        return null;
    }

    private static RightValue handleArrayElementAccess(RightValue variable, ArrayElementAccessLeftValueModifier modifier, boolean hasNext, RightValue rightValue, Interpreter interpreter) throws ScriptBasicException {
        Iterator expressionIterator = modifier.getIndexList().iterator();
        while (expressionIterator.hasNext()) {
            Expression expression = (Expression)expressionIterator.next();
            RightValue index = expression.evaluate(interpreter);
            if (variable instanceof BasicArray) {
                variable = BasicLeftValue.handleBasicArrayElementAccess((BasicArray)((Object)variable), RightValueUtility.convert2Integer(index), hasNext || expressionIterator.hasNext(), rightValue, interpreter);
                continue;
            }
            throw new BasicRuntimeException(String.valueOf(variable) + " is not an array, can not access its index");
        }
        return variable;
    }

    private static RightValue handleBasicArrayElementAccess(BasicArray variable, Integer index, boolean hasNext, RightValue rightValue, Interpreter interpreter) throws ScriptBasicException {
        if (hasNext) {
            RightValue arrayElement;
            Object object = variable.get(index);
            if (object instanceof RightValue) {
                arrayElement = (RightValue)object;
            } else {
                arrayElement = new BasicArrayValue(interpreter);
                variable.set(index, arrayElement);
            }
            return arrayElement;
        }
        variable.set(index, rightValue);
        return null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List<LeftValueModifier> getModifiers() {
        return this.modifiers;
    }

    public boolean hasModifiers() {
        return this.modifiers.size() > 0;
    }

    public void addModifier(LeftValueModifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public void setValue(RightValue rightValue, Interpreter interpreter) throws ScriptBasicException {
        HierarchicalVariableMap variableMap = interpreter.getVariables();
        if (this.modifiers.isEmpty()) {
            LOG.debug("setting the variable '{}'", this.getIdentifier());
            variableMap.setVariable(this.getIdentifier(), rightValue);
        } else {
            RightValue variableCurrentValue = variableMap.getVariableValue(this.getIdentifier());
            variableCurrentValue = this.emptyArrayIfUnderOrElseSelf(variableCurrentValue, interpreter);
            this.handleAllAccessModifier(rightValue, interpreter, variableCurrentValue);
        }
    }

    private void handleAllAccessModifier(RightValue rightValue, Interpreter interpreter, RightValue variableCurrentValue) throws ScriptBasicException {
        Iterator<LeftValueModifier> modifierIterator = this.modifiers.iterator();
        while ((variableCurrentValue = BasicLeftValue.handleAccessModifier(variableCurrentValue, modifierIterator.next(), modifierIterator.hasNext(), rightValue, interpreter)) != null) {
        }
    }

    private RightValue emptyArrayIfUnderOrElseSelf(RightValue value, Interpreter interpreter) throws ScriptBasicException {
        RightValue newValue;
        if (value == null) {
            newValue = new BasicArrayValue(interpreter);
            interpreter.getVariables().setVariable(this.getIdentifier(), newValue);
        } else {
            newValue = value;
        }
        return newValue;
    }
}

