/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.operators;

import com.scriptbasic.executors.operators.AbstractBinaryFullCircuitOperator;
import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.RightValue;

public abstract class AbstractBinaryFullCircuitNumericOperator<T extends Number>
extends AbstractBinaryFullCircuitOperator {
    protected abstract RightValue operateOnDoubleDouble(Double var1, Double var2);

    protected abstract RightValue operateOnDoubleLong(Double var1, Long var2);

    protected abstract RightValue operateOnLongDouble(Long var1, Double var2);

    protected abstract RightValue operateOnLongLong(Long var1, Long var2);

    protected abstract RightValue operateOnDate(Long var1, Long var2);

    protected RightValue operateOnValues(RightValue leftOperand, RightValue rightOperand) throws BasicRuntimeException {
        throw new BasicRuntimeException(this.operatorName() + " operator applied to non numeric argument");
    }

    protected abstract String operatorName();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final RightValue evaluateOn(RightValue leftOperand, RightValue rightOperand) throws BasicRuntimeException {
        if (leftOperand == null) throw new BasicRuntimeException("Can not execute the operation on undefined value.");
        if (rightOperand == null) {
            throw new BasicRuntimeException("Can not execute the operation on undefined value.");
        }
        if (leftOperand.isNumeric() == false) return this.operateOnValues(leftOperand, rightOperand);
        if (rightOperand.isNumeric() == false) return this.operateOnValues(leftOperand, rightOperand);
        Object a = ((AbstractNumericRightValue)leftOperand).getNumericValue();
        Object b = ((AbstractNumericRightValue)rightOperand).getNumericValue();
        if (leftOperand.isDouble().booleanValue()) {
            if (rightOperand.isDouble().booleanValue()) {
                return this.operateOnDoubleDouble((Double)a, (Double)b);
            }
            if (rightOperand.isDate() == false) return this.operateOnDoubleLong((Double)a, (Long)b);
            throw new BasicRuntimeException("Can not execute the operation on double value.");
        }
        if (leftOperand.isDate().booleanValue()) {
            if (rightOperand.isLong() == false) throw new BasicRuntimeException("Can not execute the operation on double value.");
            return this.operateOnDate((Long)a, (Long)b);
        }
        if (rightOperand.isDouble().booleanValue()) {
            return this.operateOnLongDouble((Long)a, (Double)b);
        }
        if (rightOperand.isDate() == false) return this.operateOnLongLong((Long)a, (Long)b);
        return this.operateOnDate((Long)a, (Long)b);
    }
}

