/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.utility.functions.DateFunctions;
import java.time.LocalDate;

public class BasicDateValue
extends AbstractNumericRightValue<Long, LocalDate> {
    static final long DATE_ZERO_TO_EPOCH_DAYS = DateFunctions.DATE_ZERO.toEpochDay();

    public BasicDateValue(LocalDate localDate) {
        this.setValue(localDate);
    }

    public String toString() {
        DateFunctions.DateFormatter dateFormatter = DateFunctions.getDateFormatter();
        LocalDate localDate = (LocalDate)this.getValue();
        return dateFormatter.formatDate(localDate);
    }

    public static BasicDateValue fromLong(long l) {
        LocalDate localDate = LocalDate.ofEpochDay(l + DATE_ZERO_TO_EPOCH_DAYS);
        return new BasicDateValue(localDate);
    }

    @Override
    public Long getNumericValue() {
        return ((LocalDate)this.getValue()).toEpochDay() - DATE_ZERO_TO_EPOCH_DAYS;
    }
}

