/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.executors.rightvalues.BasicDateValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicEmptyValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.RightValue;

public class BasicLongValue
extends AbstractNumericRightValue<Long, Long> {
    public BasicLongValue(Long i) {
        this.setValue(i);
    }

    public static Long asLong(RightValue rv, String errorMessageForNull) throws BasicRuntimeException {
        Long value = BasicLongValue.asLong(rv);
        if (value == null) {
            throw new BasicRuntimeException(errorMessageForNull);
        }
        return value;
    }

    public static Long asLong(RightValue rv) throws BasicRuntimeException {
        Object o;
        if (rv.isBoolean().booleanValue()) {
            return (Boolean)((BasicBooleanValue)rv).getValue() != false ? 1L : 0L;
        }
        if (rv.isString().booleanValue()) {
            String s = (String)((BasicStringValue)rv).getValue();
            if (s == null) {
                return null;
            }
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new BasicRuntimeException("Can not convert value to long", e);
            }
        }
        if (rv.isLong().booleanValue()) {
            return (Long)((BasicLongValue)rv).getValue();
        }
        if (rv.isDate().booleanValue()) {
            return ((BasicDateValue)rv).getNumericValue();
        }
        if (rv.isDouble().booleanValue()) {
            return ((Double)((BasicDoubleValue)rv).getValue()).longValue();
        }
        if (rv.isJavaObject().booleanValue() && (o = ((BasicJavaObjectValue)rv).getValue()) instanceof Long) {
            return (Long)o;
        }
        if (rv == BasicEmptyValue.EMPTY_VALUE) {
            return 0L;
        }
        throw new BasicRuntimeException("Can not convert value to long");
    }

    public String toString() {
        try {
            return "" + BasicLongValue.asLong(this);
        }
        catch (BasicRuntimeException e) {
            return super.toString();
        }
    }

    @Override
    public Long getNumericValue() {
        return (Long)this.getValue();
    }
}

