/*
 * Decompiled with CFR 0.152.
 */
package snlogic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import models.ActionResult;
import models.ActionType;
import models.ClientFingurePrint;
import models.EventOptions;
import models.SecureNativeOptions;
import models.SnEvent;
import models.User;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import snlogic.EventManager;
import snlogic.EventTypes;
import snlogic.Utils;

public class SnEventManager
implements EventManager {
    private final String SN_COOKIE_NAME = "_sn";
    private final String USERAGENT_HEADER = "user-agent";
    private final String EMPTY = "";
    private final String USER_AGENT_VALUE = "snlogic.SecureNative-java";
    private final String SN_VERSION = "SN-Version";
    private final String SN_VERSION_VALUE = "";
    private SecureNativeOptions options;
    private CloseableHttpClient client;
    private String apiKey;
    private Utils utils;

    public SnEventManager(String apiKey, SecureNativeOptions options) throws Exception {
        if (Strings.isNullOrEmpty((String)apiKey) || options == null) {
            throw new Exception("You must pass your snlogic.SecureNative api key");
        }
        this.client = this.initializeHttpClient(options);
        this.options = options;
        this.apiKey = apiKey;
        this.utils = new Utils();
    }

    @Override
    public SnEvent buildEvent(HttpServletRequest request, EventOptions options) {
        String decodedCookie = this.utils.base64decode(this.utils.getCookie(request, options != null && !Strings.isNullOrEmpty((String)options.getCookieName()) ? options.getCookieName() : "_sn"));
        ClientFingurePrint clientFP = this.utils.parseClientFP(decodedCookie);
        String eventype = options == null || Strings.isNullOrEmpty((String)options.getEventType()) ? EventTypes.types.get((Object)EventTypes.EventKey.LOG_IN) : options.getEventType();
        String cid = clientFP != null ? clientFP.getCid() : "";
        String vid = UUID.randomUUID().toString();
        String fp = clientFP != null ? clientFP.getFp() : "";
        String ip = options != null && options.getIp() != null ? options.getIp() : this.utils.remoteIpFromRequest(request);
        String remoteIP = request.getRemoteAddr();
        String userAgent = options != null && options.getUserAgent() != null ? options.getUserAgent() : request.getHeader("user-agent");
        User user = options != null && options.getUser() != null ? options.getUser() : new User("anonymous", null, null);
        String device = options != null && options.getDevice() != null ? options.getDevice() : "";
        HashMap params = options != null && options.getParams() != null ? options.getParams() : new HashMap();
        return new SnEvent(eventype, cid, vid, fp, ip, remoteIP, userAgent, user, Instant.now().getEpochSecond(), device);
    }

    @Override
    public ActionResult sendSync(SnEvent event, String requestUrl) {
        ObjectMapper mapper = new ObjectMapper();
        String stringEvent = null;
        try {
            String line;
            stringEvent = mapper.writeValueAsString((Object)event);
            HttpPost httpPost = new HttpPost(requestUrl);
            httpPost.addHeader("Authorization", this.apiKey);
            httpPost.addHeader("user-agent", "snlogic.SecureNative-java");
            httpPost.addHeader("SN-Version", this.getVersion());
            httpPost.addHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(stringEvent));
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() > 210) {
                new ActionResult(ActionType.type.ALLOW, 0.0, new String[0]);
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            return (ActionResult)mapper.readValue(result.toString(), ActionResult.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ActionResult(ActionType.type.ALLOW, 0.0, new String[0]);
        }
    }

    @Override
    public void sendAsync(SnEvent event, String url) {
    }

    private void setTimeout(Runnable runnable, int delay) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                runnable.run();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }).start();
    }

    private CloseableHttpClient initializeHttpClient(SecureNativeOptions options) {
        return HttpClients.custom().setUserAgent("snlogic.SecureNative-java").setConnectionTimeToLive(options.getTimeout(), TimeUnit.MILLISECONDS).setDefaultHeaders(Arrays.asList(new BasicHeader("SN-Version", ""), new BasicHeader("Authorization", this.apiKey))).build();
    }

    private String getVersion() {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model read = reader.read((Reader)new FileReader("pom.xml"));
            return read.getVersion();
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

