/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.securenative.Logger;
import com.securenative.events.Agent;
import com.securenative.events.Event;
import com.securenative.events.Framework;
import com.securenative.events.Os;
import com.securenative.events.SnProcess;
import com.securenative.events.SnRuntime;
import com.securenative.models.EventTypes;
import com.securenative.packagemanager.PackageManager;
import com.securenative.packagemanager.SnPackage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZonedDateTime;

public class AgentLoginEvent
implements Event {
    private static final String PACKAGE_FILE_NAME = "pom.xml";
    @JsonProperty(value="eventType")
    public String eventType;
    @JsonProperty(value="ts")
    public Long ts;
    @JsonProperty(value="package")
    public SnPackage snPackage;
    @JsonProperty(value="appName")
    public String appName;
    @JsonProperty(value="process")
    public SnProcess process;
    @JsonProperty(value="runtime")
    public SnRuntime snRuntime;
    @JsonProperty(value="os")
    public Os os;
    @JsonProperty(value="framework")
    public Framework framework;
    @JsonProperty(value="agent")
    public Agent agent;

    public AgentLoginEvent(String framework, String frameworkVersion, String appName) {
        String cwd = System.getProperty("user.dir");
        SnPackage appPkg = PackageManager.getPackage(String.join((CharSequence)cwd, PACKAGE_FILE_NAME));
        SnPackage agentPkg = PackageManager.getPackage(String.join((CharSequence)"/sdk-base/", PACKAGE_FILE_NAME));
        this.appName = appName;
        this.framework = new Framework(framework, frameworkVersion);
        this.snPackage = new SnPackage(appPkg.getName(), appPkg.getVersion(), appPkg.getDependencies(), appPkg.getDependenciesHash());
        this.eventType = EventTypes.AGENT_LOG_IN.getType();
        this.snRuntime = new SnRuntime("java", System.getProperty("java.version"));
        this.process = new SnProcess(ProcessHandle.current().pid(), ProcessHandle.current().getClass().getName(), System.getProperty("user.dir"));
        String hostId = null;
        String hostname = null;
        try {
            hostId = InetAddress.getLocalHost().getHostAddress();
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Logger.getLogger().debug(String.join((CharSequence)"Could not find hostname and/or host address; ", e.toString()));
        }
        this.os = new Os(hostId, hostname, System.getProperty("os.arch"), System.getProperty("os.name"), Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().totalMemory());
        this.agent = new Agent("Java", agentPkg.getVersion(), System.getProperty("java.class.path"));
        this.ts = ZonedDateTime.now().toEpochSecond();
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }
}

