package com.securenative.processors;

import com.securenative.utils.Logger;
import com.securenative.actions.Action;
import com.securenative.actions.ActionList;
import com.securenative.models.SetType;

public class WhitelistIp extends Processor {
    private Action action;

    public WhitelistIp(Action action) {
        this.action = action;
    }

    @Override
    public void apply() {
        if (this.action.getValues() != null) {
            this.action.getValues().forEach(value -> {
                Logger.getLogger().debug(String.format("Whitelisting ip: %s", value));
                ActionList.whitelist.add(SetType.IP.toString(), value, this.action.getTtl());
            });
        }
    }
}
