/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.events;

import com.securenative.configurations.SecureNativeOptions;
import com.securenative.events.AgentHeartBeatEvent;
import com.securenative.events.AgentLoginEvent;
import com.securenative.events.AgentLogoutEvent;
import com.securenative.events.ConfigEvent;
import com.securenative.events.ErrorEvent;
import com.securenative.events.Event;
import com.securenative.events.LoginChallengeEvent;
import com.securenative.events.LoginEvent;
import com.securenative.events.LoginFailureEvent;
import com.securenative.events.LogoutEvent;
import com.securenative.events.PerformanceEvent;
import com.securenative.events.RequestEvent;
import com.securenative.events.SDKEvent;
import com.securenative.models.EventOptions;
import com.securenative.models.EventTypes;
import com.securenative.models.RequestOptions;
import com.securenative.models.User;
import javax.servlet.ServletRequest;

public class EventFactory {
    public static Event createEvent(EventTypes eventType, Object ... args) {
        if (eventType == EventTypes.AGENT_LOG_IN) {
            String framework = (String)args[0];
            String frameworkVersion = (String)args[1];
            String appName = (String)args[2];
            return new AgentLoginEvent(framework, frameworkVersion, appName);
        }
        if (eventType == EventTypes.AGENT_LOG_OUT) {
            return new AgentLogoutEvent();
        }
        if (eventType == EventTypes.ERROR) {
            String stackTrace = (String)args[0];
            String message = (String)args[1];
            return new ErrorEvent(stackTrace, message);
        }
        if (eventType == EventTypes.CONFIG) {
            String hostId = (String)args[0];
            String appName = (String)args[1];
            return new ConfigEvent(hostId, appName);
        }
        if (eventType == EventTypes.HEARTBEAT) {
            return new AgentHeartBeatEvent();
        }
        if (eventType == EventTypes.REQUEST) {
            RequestOptions options = (RequestOptions)args[0];
            return new RequestEvent(options);
        }
        if (eventType == EventTypes.SDK) {
            ServletRequest request = (ServletRequest)args[0];
            EventOptions eventOptions = (EventOptions)args[1];
            SecureNativeOptions snOptions = (SecureNativeOptions)args[2];
            return new SDKEvent(request, eventOptions, snOptions);
        }
        if (eventType == EventTypes.LOG_IN) {
            User user = (User)args[0];
            return new LoginEvent(user);
        }
        if (eventType == EventTypes.LOG_OUT) {
            User user = (User)args[0];
            return new LogoutEvent(user);
        }
        if (eventType == EventTypes.LOG_IN_CHALLENGE) {
            User user = (User)args[0];
            return new LoginChallengeEvent(user);
        }
        if (eventType == EventTypes.LOG_IN_FAILURE) {
            User user = (User)args[0];
            return new LoginFailureEvent(user);
        }
        if (eventType == EventTypes.PERFORMANCE) {
            return new PerformanceEvent();
        }
        return null;
    }
}

