/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.agent;

import com.securenative.agent.SecureNative;
import com.securenative.agent.config.ConfigurationManager;
import com.securenative.agent.config.SecureNativeOptions;
import com.securenative.agent.exceptions.SecureNativeSDKException;
import com.securenative.agent.module.ModuleManager;
import com.securenative.agent.snpackage.PackageItem;
import com.securenative.agent.snpackage.PackageManager;
import com.securenative.agent.utils.Utils;
import java.lang.instrument.Instrumentation;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class SecureNativeAgent {
    public static void premain(String args, Instrumentation inst) {
        try {
            String PACKAGE_FILE_NAME = "/pom.xml";
            PackageItem appPkg = PackageManager.getPackage(System.getProperty("user.dir").concat(PACKAGE_FILE_NAME));
            SecureNativeOptions config = ConfigurationManager.loadConfig();
            config.setAppName(appPkg.getName());
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            rootLogger.setLevel(Level.FINE);
            System.out.println(String.format("Loaded SecureNative Agent Configurations %s", config.toString()));
            ModuleManager moduleManager = new ModuleManager(appPkg);
            SecureNative secureNative = null;
            try {
                System.out.println("Starting SecureNative Java Agent");
                secureNative = new SecureNative(moduleManager, config);
            }
            catch (SecureNativeSDKException e) {
                System.err.println("Could not find SecureNative api key. aborting.");
                System.exit(1);
            }
            System.out.println("Starting version compatibility check");
            if (Utils.versionCompare(System.getProperty("java.version"), config.getMinSupportedVersion()) < 0) {
                System.err.println(String.format("This version of Java %s isn't supported by SecureNative, minimum required version is %s", appPkg.getVersion(), config.getMinSupportedVersion()));
                System.err.println("Visit our docs to find out more: https://docs.securenative.com/docs/integrations/sdk/#java");
                System.exit(1);
            }
            SecureNative finalSecureNative = secureNative;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.out.println("Received exit signal, exiting SecureNative agent..");
                finalSecureNative.stopAgent();
                System.exit(0);
            }));
            secureNative.startAgent();
            System.out.println("SecureNative agent was successfully started");
        }
        catch (Exception e) {
            System.out.println("Failed to start SecureNative Java Agent");
            System.out.println(e.getMessage());
        }
    }
}

