/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.agent.config;

import com.securenative.agent.config.SecureNativeOptions;
import com.securenative.agent.enums.FailoverStrategy;

public class SecureNativeConfigurationBuilder {
    private String apiKey;
    private String apiUrl;
    private int interval;
    private int maxEvents;
    private int timeout;
    private Boolean autoSend;
    private Boolean disable;
    private String logLevel;
    private FailoverStrategy failoverStrategy;
    private long heartbeatDelay;
    private long heartbeatPeriod;
    private long configUpdateDelay;
    private long configUpdatePeriod;
    private String appName;

    private SecureNativeConfigurationBuilder() {
    }

    public static SecureNativeConfigurationBuilder defaultConfigBuilder() {
        return new SecureNativeConfigurationBuilder().withApiKey(null).withApiUrl("https://api.securenative.com/collector/api/v1").withInterval(1000).withTimeout(120000).withMaxEvents(1000).withAutoSend(true).withDisable(false).withLogLevel("fatal").withHeartbeatDelay(0L).withHeartbeatPeriod(300000L).withConfigUpdateDelay(0L).withConfigUpdatePeriod(300000L).withAppName(null).withFailoverStrategy(FailoverStrategy.FAIL_OPEN);
    }

    public SecureNativeConfigurationBuilder withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public SecureNativeConfigurationBuilder withApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    public SecureNativeConfigurationBuilder withInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public SecureNativeConfigurationBuilder withMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
        return this;
    }

    public SecureNativeConfigurationBuilder withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public SecureNativeConfigurationBuilder withAutoSend(Boolean autoSend) {
        this.autoSend = autoSend;
        return this;
    }

    public SecureNativeConfigurationBuilder withDisable(Boolean disable) {
        this.disable = disable;
        return this;
    }

    public SecureNativeConfigurationBuilder withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public SecureNativeConfigurationBuilder withFailoverStrategy(FailoverStrategy failoverStrategy) {
        this.failoverStrategy = failoverStrategy;
        return this;
    }

    public SecureNativeConfigurationBuilder withHeartbeatDelay(long heartbeatDelay) {
        this.heartbeatDelay = heartbeatDelay;
        return this;
    }

    public SecureNativeConfigurationBuilder withHeartbeatPeriod(long heartbeatPeriod) {
        this.heartbeatPeriod = heartbeatPeriod;
        return this;
    }

    public SecureNativeConfigurationBuilder withConfigUpdateDelay(long configUpdateDelay) {
        this.configUpdateDelay = configUpdateDelay;
        return this;
    }

    public SecureNativeConfigurationBuilder withConfigUpdatePeriod(long configUpdatePeriod) {
        this.configUpdatePeriod = configUpdatePeriod;
        return this;
    }

    public SecureNativeConfigurationBuilder withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public SecureNativeOptions build() {
        return new SecureNativeOptions(this.apiKey, this.apiUrl, this.interval, this.maxEvents, this.timeout, this.autoSend, this.disable, this.logLevel, this.failoverStrategy, this.heartbeatDelay, this.heartbeatPeriod, this.configUpdateDelay, this.configUpdatePeriod, this.appName);
    }
}

