/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.DefaultTestNGContext;
import com.seleniumtests.core.IContextAttributeListener;
import com.seleniumtests.core.SeleniumTestsContext;
import com.seleniumtests.helper.XMLUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.xml.XmlTest;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeleniumTestsContextManager {
    private static List<IContextAttributeListener> contextAttributeListeners = Collections.synchronizedList(new ArrayList());
    private static SeleniumTestsContext globalContext;
    private static Map<String, SeleniumTestsContext> testLevelContext;
    private static ThreadLocal<SeleniumTestsContext> threadLocalContext;

    public static void addContextAttributeListener(IContextAttributeListener listener) {
        contextAttributeListeners.add(listener);
    }

    public static SeleniumTestsContext getGlobalContext() {
        if (globalContext == null) {
            System.out.println("Initialize default GlobalContext");
            SeleniumTestsContextManager.initGlobalContext(new DefaultTestNGContext());
        }
        return globalContext;
    }

    public static SeleniumTestsContext getTestLevelContext(ITestContext testContext) {
        if (testContext != null && testContext.getCurrentXmlTest() != null) {
            if (testLevelContext.get(testContext.getCurrentXmlTest().getName()) == null) {
                SeleniumTestsContextManager.initTestLevelContext(testContext, testContext.getCurrentXmlTest());
            }
            return testLevelContext.get(testContext.getCurrentXmlTest().getName());
        }
        return null;
    }

    public static SeleniumTestsContext getTestLevelContext(String testName) {
        return testLevelContext.get(testName);
    }

    public static SeleniumTestsContext getThreadContext() {
        if (threadLocalContext.get() == null) {
            System.out.println("Initialize default ThreadContext");
            SeleniumTestsContextManager.initThreadContext(null, null);
        }
        return threadLocalContext.get();
    }

    public static void initGlobalContext(ITestContext testNGCtx) {
        testNGCtx = SeleniumTestsContextManager.getContextFromConfigFile(testNGCtx);
        globalContext = new SeleniumTestsContext(testNGCtx);
        SeleniumTestsContextManager.loadCustomizedContextAttribute(testNGCtx, globalContext);
    }

    private static ITestContext getContextFromConfigFile(ITestContext iTestContext) {
        if (iTestContext != null && iTestContext.getSuite().getParameter("testConfig") != null) {
            File suiteFile = new File(iTestContext.getSuite().getXmlSuite().getFileName());
            String configFile = suiteFile.getPath().replace(suiteFile.getName(), "") + iTestContext.getSuite().getParameter("testConfig");
            NodeList nList = XMLUtility.getXMLNodes(configFile, "parameter");
            Map parameters = iTestContext.getSuite().getXmlSuite().getParameters();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node nNode = nList.item(i);
                parameters.put(nNode.getAttributes().getNamedItem("name").getNodeValue(), nNode.getAttributes().getNamedItem("value").getNodeValue());
            }
            iTestContext.getSuite().getXmlSuite().setParameters(parameters);
        }
        return iTestContext;
    }

    public static void initTestLevelContext(ITestContext testNGCtx, XmlTest xmlTest) {
        SeleniumTestsContext seleniumTestsCtx = new SeleniumTestsContext(testNGCtx);
        if (xmlTest != null) {
            Map testParameters = xmlTest.getTestParameters();
            for (Map.Entry entry : testParameters.entrySet()) {
                seleniumTestsCtx.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        testLevelContext.put(xmlTest.getName(), seleniumTestsCtx);
    }

    public static void initTestLevelContext(XmlTest xmlTest) {
        SeleniumTestsContextManager.initTestLevelContext(globalContext.getTestNGContext(), xmlTest);
    }

    public static void initThreadContext() {
        SeleniumTestsContextManager.initThreadContext(globalContext.getTestNGContext(), null);
    }

    public static void initThreadContext(ITestContext testNGCtx) {
        SeleniumTestsContextManager.initThreadContext(testNGCtx, null);
    }

    public static void initThreadContext(ITestContext testNGCtx, XmlTest xmlTest) {
        SeleniumTestsContext seleniumTestsCtx = new SeleniumTestsContext(testNGCtx);
        SeleniumTestsContextManager.loadCustomizedContextAttribute(testNGCtx, seleniumTestsCtx);
        if (xmlTest != null) {
            Map testParameters = xmlTest.getTestParameters();
            for (Map.Entry entry : testParameters.entrySet()) {
                if (System.getProperty((String)entry.getKey()) != null) continue;
                seleniumTestsCtx.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        threadLocalContext.set(seleniumTestsCtx);
    }

    public static void initThreadContext(XmlTest xmlTest) {
        SeleniumTestsContextManager.initThreadContext(globalContext.getTestNGContext(), xmlTest);
    }

    private static void loadCustomizedContextAttribute(ITestContext testNGCtx, SeleniumTestsContext seleniumTestsCtx) {
        for (int i = 0; i < contextAttributeListeners.size(); ++i) {
            contextAttributeListeners.get(i).load(testNGCtx, seleniumTestsCtx);
        }
    }

    public static void setGlobalContext(SeleniumTestsContext ctx) {
        globalContext = ctx;
    }

    public static void setThreadContext(SeleniumTestsContext ctx) {
        threadLocalContext.set(ctx);
    }

    static {
        testLevelContext = Collections.synchronizedMap(new HashMap());
        threadLocalContext = new ThreadLocal();
    }
}

