/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.opera.core.systems.OperaProfile;
import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.helper.FileUtility;
import com.seleniumtests.helper.OSUtility;
import com.seleniumtests.operaprofile.OperaProfileMarker;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.remote.DesiredCapabilities;

public class OperaCapabilitiesFactory
implements ICapabilitiesFactory {
    private static Object lockProfile = new Object();
    private static boolean isProfileCreated = false;

    @Override
    public DesiredCapabilities createCapabilities(DriverConfig cfg) {
        DesiredCapabilities capability = DesiredCapabilities.opera();
        capability.setBrowserName(DesiredCapabilities.opera().getBrowserName());
        if (cfg.isEnableJavascript()) {
            capability.setJavascriptEnabled(true);
        } else {
            capability.setJavascriptEnabled(false);
        }
        capability.setCapability("takesScreenshot", true);
        capability.setCapability("acceptSslCerts", true);
        if (cfg.getBrowserVersion() != null) {
            capability.setVersion(cfg.getBrowserVersion());
        }
        if (cfg.getPlatform() != null) {
            capability.setPlatform(cfg.getPlatform());
        }
        OperaProfile profile = this.getOperaProfile(cfg);
        capability.setCapability("opera.profile", (Object)profile);
        if (cfg.getProxyHost() != null) {
            Proxy proxy = cfg.getProxy();
            capability.setCapability("proxy", (Object)proxy);
        }
        return capability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized OperaProfile getOperaProfile(DriverConfig cfg) {
        OperaProfile profile = null;
        Class<OperaCapabilitiesFactory> clazz = OperaCapabilitiesFactory.class;
        synchronized (OperaCapabilitiesFactory.class) {
            String path = cfg.getOperaProfilePath();
            path = this.getOperaProfilePath(path);
            profile = path != null ? new OperaProfile(path) : new OperaProfile();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return profile;
        }
    }

    protected String getOperaProfilePath(String path) {
        String realPath = null;
        if (path != null && !new File(path).exists()) {
            TestLogging.log("Profile path of Opera Browser:" + path + " not found, use default");
            path = null;
        }
        if (path != null) {
            realPath = path;
        } else {
            try {
                String slash = "\\";
                String profilePath = "C:\\grid\\profile";
                if (!OSUtility.isWindows()) {
                    slash = "/";
                }
                profilePath = this.getClass().getResource("/").getFile() + slash + "defaultOperaProfile";
                this.extractDefaultProfile(profilePath);
                String tempProfilePath = this.getClass().getResource("/").getFile() + slash + new Date().hashCode() + Thread.currentThread().getId();
                FileUtils.copyDirectory((File)new File(profilePath), (File)new File(tempProfilePath));
                realPath = tempProfilePath + slash + "operaProfile";
            }
            catch (Exception e) {
                e.printStackTrace();
                realPath = null;
            }
        }
        System.out.println("OperaProfile: " + realPath);
        return realPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractDefaultProfile(String profilePath) throws IOException {
        Object object = lockProfile;
        synchronized (object) {
            try {
                if (!isProfileCreated) {
                    System.out.println("start create profile");
                    FileUtility.extractJar(profilePath, OperaProfileMarker.class);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        isProfileCreated = true;
    }
}

