/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.google.gdata.util.common.html.HtmlToText;
import com.seleniumtests.driver.ScreenShot;
import com.seleniumtests.helper.StringUtility;
import com.seleniumtests.reporter.PluginsHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.testng.ITestResult;
import org.testng.Reporter;

public class TestLogging {
    private static Map<String, Map<String, Map<String, List<String>>>> logMap = Collections.synchronizedMap(new HashMap());

    public static void errorLogger(String message) {
        message = "<li><b><font color='#6600CC'>" + message + "</font></b></li>";
        TestLogging.log(message, false, false);
    }

    public static Logger getLogger(Class<?> cls) {
        boolean rootIsConfigured = Logger.getRootLogger().getAllAppenders().hasMoreElements();
        if (!rootIsConfigured) {
            BasicConfigurator.configure();
            Logger.getRootLogger().setLevel(Level.INFO);
            Appender appender = (Appender)Logger.getRootLogger().getAllAppenders().nextElement();
            appender.setLayout((Layout)new PatternLayout(" %-5p %d [%t] %C{1}: %m%n"));
        }
        return Logger.getLogger(cls);
    }

    public static Map<String, Map<String, List<String>>> getPageListenerLog(String pageListenerClassName) {
        return logMap.get(pageListenerClassName);
    }

    public static List<String> getPageListenerLogByMethodInstance(ITestResult testResult) {
        for (Map.Entry<String, Map<String, Map<String, List<String>>>> listenerEntry : logMap.entrySet()) {
            Map<String, Map<String, List<String>>> pageMap;
            Iterator<Map.Entry<String, Map<String, List<String>>>> iterator;
            if (!PluginsHelper.getInstance().isTestResultEffected(listenerEntry.getKey()) || !(iterator = (pageMap = listenerEntry.getValue()).entrySet().iterator()).hasNext()) continue;
            Map.Entry<String, Map<String, List<String>>> pageEntry = iterator.next();
            Map<String, List<String>> errorMap = pageEntry.getValue();
            String methodInstance = StringUtility.constructMethodSignature(testResult.getMethod().getConstructorOrMethod().getMethod(), testResult.getParameters());
            return errorMap.get(methodInstance);
        }
        return null;
    }

    public static void logInfo(String message) {
        message = "<li><font color='#00cd00'>" + message + "</font></li>";
        TestLogging.log(message, false, false);
    }

    public static void log(String message) {
        TestLogging.log(message, false, false);
    }

    public static void log(String message, boolean logToStandardOutput) {
        TestLogging.log(message, false, logToStandardOutput);
    }

    public static void log(String message, boolean failed, boolean logToStandardOutput) {
        if (message == null) {
            message = "";
        }
        message = message.replaceAll("\\n", "<br/>");
        if (failed) {
            message = "<span style=\"font-weight:bold;color:#cc0052;\">" + message + "</span>";
        }
        Reporter.log((String)TestLogging.escape(message), (boolean)logToStandardOutput);
    }

    public static String escape(String message) {
        return message.replaceAll("\\n", "<br/>").replaceAll("<", "@@lt@@").replaceAll(">", "^^greaterThan^^");
    }

    public static String unEscape(String message) {
        message = message.replaceAll("<br/>", "\\n").replaceAll("@@lt@@", "<").replaceAll("\\^\\^gt\\^\\^", ">");
        message = HtmlToText.htmlToPlainText((String)message);
        return message;
    }

    public static void logWebOutput(String url, String message, boolean failed) {
        TestLogging.log("Output: " + message + "<br/>", failed, false);
    }

    public static void logWebStep(String url, String message, boolean failed) {
        TestLogging.log("<li>" + (failed ? "<b>FailedStep</b>: " : " ") + message + "</li>", failed, false);
    }

    public static String buildScreenshotLog(ScreenShot screenShot) {
        StringBuffer sbMessage = new StringBuffer("");
        if (screenShot.getLocation() != null) {
            sbMessage.append("<a href='" + screenShot.getLocation() + "' target=url>Application URL</a>");
        }
        if (screenShot.getHtmlSourcePath() != null) {
            sbMessage.append(" | <a href='" + screenShot.getHtmlSourcePath() + "' target=html>Application HTML Source</a>");
        }
        if (screenShot.getImagePath() != null) {
            sbMessage.append(" | <a href='" + screenShot.getImagePath() + "' class='lightbox'>Application Snapshot</a>");
        }
        return sbMessage.toString();
    }

    public static void warning(String message) {
        message = "<li><font color='#FFFF00'>" + message + "</font></li>";
        TestLogging.log(message, false, false);
    }
}

