/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.TestLogging;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class TestRetryAnalyzer
implements IRetryAnalyzer {
    private static final String TEST_RETRY_COUNT = "testRetryCount";
    private int count = 1;
    private int maxCount = 2;

    public TestRetryAnalyzer() {
        String retryMaxCount = System.getProperty(TEST_RETRY_COUNT);
        if (retryMaxCount != null) {
            this.maxCount = Integer.parseInt(retryMaxCount);
        }
    }

    public void setMaxCount(int count) {
        this.maxCount = count;
    }

    public int getCount() {
        return this.count;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public synchronized boolean retry(ITestResult result) {
        String testClassName = String.format("%s.%s", result.getMethod().getRealClass().toString(), result.getMethod().getMethodName());
        if (this.count <= this.maxCount) {
            result.setAttribute("RETRY", (Object)new Integer(this.count));
            TestLogging.log("[RETRYING] " + testClassName + " FAILED, " + "Retrying " + this.count + " time", true);
            ++this.count;
            return true;
        }
        return false;
    }
}

