/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.driver;

import com.seleniumtests.driver.BrowserType;
import com.seleniumtests.driver.DriverMode;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class DriverConfig {
    private boolean setAssumeUntrustedCertificateIssuer = true;
    private boolean setAcceptUntrustedCertificates = true;
    private boolean enableJavascript = true;
    private WebDriver driver;
    private BrowserType browser = BrowserType.FireFox;
    private DriverMode mode = DriverMode.LOCAL;
    private String hubUrl;
    private String ffProfilePath;
    private String operaProfilePath;
    private String ffBinPath;
    private String ieDriverPath;
    private String chromeDriverPath;
    private String chromeBinPath;
    private int webSessionTimeout = 90000;
    public static final int DEFAULT_IMPLICIT_WAIT_TIMEOUT = 5;
    public static final int DEFAULT_EXPLICIT_WAIT_TIME_OUT = 15;
    public static final int DEFAULT_PAGE_LOAD_TIMEOUT = 90;
    private double implicitWaitTimeout = 5.0;
    private int explicitWaitTimeout = 15;
    private int pageLoadTimeout = 90;
    private String outputDirectory;
    private String browserVersion;
    private Platform webPlatform;
    private String userAgentOverride;
    private String ntlmAuthTrustedUris;
    private String browserDownloadDir;
    private boolean addJSErrorCollectorExtension = false;
    private ArrayList<WebDriverEventListener> webDriverListeners;
    private boolean useFirefoxDefaultProfile = true;
    private int browserWindowWidth = -1;
    private int browserWindowHeight = -1;
    private String proxyHost;
    private String testType;
    private String automationName;
    private String appiumServerURL;
    private String mobilePlatformName;
    private String mobilePlatformVersion;
    private String deviceName;
    private String app;
    private String browserName;
    private String appPackage;
    private String appActivity;
    private String newCommandTimeout;

    public ArrayList<WebDriverEventListener> getWebDriverListeners() {
        return this.webDriverListeners;
    }

    public void setWebDriverListeners(ArrayList<WebDriverEventListener> webDriverListeners) {
        this.webDriverListeners = webDriverListeners;
    }

    public void setWebDriverListeners(String listeners) {
        String[] list;
        ArrayList<WebDriverEventListener> listenerList = new ArrayList<WebDriverEventListener>();
        for (String aList : list = listeners.split(",")) {
            WebDriverEventListener listener = null;
            try {
                if (aList.equals("")) continue;
                listener = (WebDriverEventListener)Class.forName(aList).newInstance();
                listenerList.add(listener);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        this.webDriverListeners = listenerList;
    }

    public BrowserType getBrowser() {
        return this.browser;
    }

    public String getBrowserDownloadDir() {
        return this.browserDownloadDir;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public String getChromeBinPath() {
        return this.chromeBinPath;
    }

    public String getChromeDriverPath() {
        return this.chromeDriverPath;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public int getExplicitWaitTimeout() {
        if ((double)this.explicitWaitTimeout < this.getImplicitWaitTimeout()) {
            return (int)this.getImplicitWaitTimeout();
        }
        return this.explicitWaitTimeout;
    }

    public String getFirefoxBinPath() {
        return this.ffBinPath;
    }

    public String getFirefoxProfilePath() {
        if (this.ffProfilePath == null && this.getClass().getResource("/profiles/customProfileDirCUSTFF") != null) {
            try {
                return this.getClass().getResource("/profiles/customProfileDirCUSTFF").toURI().getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.ffProfilePath;
    }

    public String getHubUrl() {
        return this.hubUrl;
    }

    public String getIeDriverPath() {
        return this.ieDriverPath;
    }

    public double getImplicitWaitTimeout() {
        return this.implicitWaitTimeout;
    }

    public DriverMode getMode() {
        return this.mode;
    }

    public String getNtlmAuthTrustedUris() {
        return this.ntlmAuthTrustedUris;
    }

    public String getOperaProfilePath() {
        if (this.operaProfilePath == null && this.getClass().getResource("/profiles/operaProfile") != null) {
            try {
                return this.getClass().getResource("/profiles/operaProfile").toURI().getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.operaProfilePath;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public int getPageLoadTimeout() {
        return this.pageLoadTimeout;
    }

    public Platform getWebPlatform() {
        return this.webPlatform;
    }

    public Proxy getProxy() {
        Proxy proxy = null;
        if (this.proxyHost != null) {
            proxy = new Proxy();
            proxy.setProxyType(Proxy.ProxyType.MANUAL);
            proxy.setHttpProxy(this.proxyHost);
            proxy.setFtpProxy(this.proxyHost);
            proxy.setSslProxy(this.proxyHost);
        }
        return proxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getUserAgentOverride() {
        return this.userAgentOverride;
    }

    public int getWebSessionTimeout() {
        return this.webSessionTimeout;
    }

    public boolean isAddJSErrorCollectorExtension() {
        return this.addJSErrorCollectorExtension;
    }

    public boolean isUseFirefoxDefaultProfile() {
        return this.useFirefoxDefaultProfile;
    }

    public void setUseFirefoxDefaultProfile(boolean useFirefoxDefaultProfile) {
        this.useFirefoxDefaultProfile = useFirefoxDefaultProfile;
    }

    public boolean isEnableJavascript() {
        return this.enableJavascript;
    }

    public boolean isSetAcceptUntrustedCertificates() {
        return this.setAcceptUntrustedCertificates;
    }

    public boolean isSetAssumeUntrustedCertificateIssuer() {
        return this.setAssumeUntrustedCertificateIssuer;
    }

    public void setAddJSErrorCollectorExtension(boolean addJSErrorCollectorExtension) {
        this.addJSErrorCollectorExtension = addJSErrorCollectorExtension;
    }

    public void setBrowser(BrowserType browser) {
        this.browser = browser;
    }

    public void setBrowserDownloadDir(String browserDownloadDir) {
        this.browserDownloadDir = browserDownloadDir;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public void setChromeBinPath(String chromeBinPath) {
        this.chromeBinPath = chromeBinPath;
    }

    public void setChromeDriverPath(String chromeDriverPath) {
        this.chromeDriverPath = chromeDriverPath;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public void setEnableJavascript(boolean enableJavascript) {
        this.enableJavascript = enableJavascript;
    }

    public void setExplicitWaitTimeout(int explicitWaitTimeout) {
        this.explicitWaitTimeout = explicitWaitTimeout;
    }

    public void setFfBinPath(String ffBinPath) {
        this.ffBinPath = ffBinPath;
    }

    public void setFfProfilePath(String ffProfilePath) {
        this.ffProfilePath = ffProfilePath;
    }

    public void setHubUrl(String hubUrl) {
        this.hubUrl = hubUrl;
    }

    public void setIeDriverPath(String ieDriverPath) {
        this.ieDriverPath = ieDriverPath;
    }

    public void setImplicitWaitTimeout(double implicitWaitTimeout) {
        this.implicitWaitTimeout = implicitWaitTimeout;
    }

    public void setMode(DriverMode mode) {
        this.mode = mode;
    }

    public void setNtlmAuthTrustedUris(String ntlmAuthTrustedUris) {
        this.ntlmAuthTrustedUris = ntlmAuthTrustedUris;
    }

    public void setOperaProfilePath(String operaProfilePath) {
        this.operaProfilePath = operaProfilePath;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPageLoadTimeout(int pageLoadTimeout) {
        this.pageLoadTimeout = pageLoadTimeout;
    }

    public void setWebPlatform(Platform webPlatform) {
        this.webPlatform = webPlatform;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setSetAcceptUntrustedCertificates(boolean setAcceptUntrustedCertificates) {
        this.setAcceptUntrustedCertificates = setAcceptUntrustedCertificates;
    }

    public void setSetAssumeUntrustedCertificateIssuer(boolean setAssumeUntrustedCertificateIssuer) {
        this.setAssumeUntrustedCertificateIssuer = setAssumeUntrustedCertificateIssuer;
    }

    public void setUserAgentOverride(String userAgentOverride) {
        this.userAgentOverride = userAgentOverride;
    }

    public void setWebSessionTimeout(int webSessionTimeout) {
        this.webSessionTimeout = webSessionTimeout;
    }

    public int getBrowserWindowWidth() {
        return this.browserWindowWidth;
    }

    public void setBrowserWindowWidth(int browserWindowWidth) {
        this.browserWindowWidth = browserWindowWidth;
    }

    public int getBrowserWindowHeight() {
        return this.browserWindowHeight;
    }

    public void setBrowserWindowHeight(int browserWindowHeight) {
        this.browserWindowHeight = browserWindowHeight;
    }

    public String getAutomationName() {
        return this.automationName;
    }

    public void setAutomationName(String automationName) {
        this.automationName = automationName;
    }

    public String getMobilePlatformVersion() {
        return this.mobilePlatformVersion;
    }

    public void setMobilePlatformVersion(String mobilePlatformVersion) {
        this.mobilePlatformVersion = mobilePlatformVersion;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppActivity() {
        return this.appActivity;
    }

    public void setAppActivity(String appActivity) {
        this.appActivity = appActivity;
    }

    public String getNewCommandTimeout() {
        return this.newCommandTimeout;
    }

    public void setNewCommandTimeout(String newCommandTimeout) {
        this.newCommandTimeout = newCommandTimeout;
    }

    public String getAppiumServerURL() {
        return this.appiumServerURL;
    }

    public void setAppiumServerURL(String appiumServerURL) {
        this.appiumServerURL = appiumServerURL;
    }

    public String getMobilePlatformName() {
        return this.mobilePlatformName;
    }

    public void setMobilePlatformName(String mobilePlatformName) {
        this.mobilePlatformName = mobilePlatformName;
    }

    public String getTestType() {
        return this.testType;
    }

    public void setTestType(String testType) {
        this.testType = testType;
    }
}

