/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.webelements;

import com.seleniumtests.webelements.HtmlElement;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebElement;

public class Table
extends HtmlElement {
    private List<WebElement> rows = null;
    private List<WebElement> columns = null;

    public Table(String label, By by) {
        super(label, by);
    }

    @Override
    public void findElement() {
        super.findElement();
        try {
            this.rows = this.element.findElements(By.tagName((String)"tr"));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public int getColumnCount() {
        if (this.rows == null) {
            this.findElement();
        }
        if (this.rows != null && !this.rows.isEmpty()) {
            try {
                this.columns = this.rows.get(0).findElements(By.tagName((String)"td"));
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            if (this.columns == null || this.columns.size() == 0) {
                try {
                    this.columns = this.rows.size() > 1 ? this.rows.get(1).findElements(By.tagName((String)"td")) : this.rows.get(0).findElements(By.tagName((String)"th"));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        if (this.columns != null) {
            return this.columns.size();
        }
        return 0;
    }

    public List<WebElement> getColumns() {
        return this.columns;
    }

    public String getContent(int row, int column) {
        if (this.rows == null) {
            this.findElement();
        }
        if (this.rows != null && !this.rows.isEmpty()) {
            try {
                this.columns = this.rows.get(row - 1).findElements(By.tagName((String)"td"));
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            if (this.columns == null || this.columns.size() == 0) {
                try {
                    this.columns = this.rows.get(row - 1).findElements(By.tagName((String)"th"));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            return this.columns.get(column - 1).getText();
        }
        return null;
    }

    public int getRowCount() {
        if (this.rows != null) {
            return this.rows.size();
        }
        this.findElement();
        int count = this.element.findElements(By.xpath((String)"tbody/tr")).size();
        if (count == 0) {
            count = this.element.findElements(By.xpath((String)"tr")).size();
        }
        return count;
    }

    public List<WebElement> getRows() {
        return this.rows;
    }

    public boolean isHasBody() {
        return this.getRows().size() > 0;
    }
}

