/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.driver.DriverConfig;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.remote.DesiredCapabilities;

public class HtmlUnitCapabilitiesFactory
implements ICapabilitiesFactory {
    @Override
    public DesiredCapabilities createCapabilities(DriverConfig webDriverConfig) {
        DesiredCapabilities capability = null;
        capability = DesiredCapabilities.htmlUnit();
        if (webDriverConfig.isEnableJavascript()) {
            capability.setJavascriptEnabled(true);
        } else {
            capability.setJavascriptEnabled(false);
        }
        capability.setCapability("takesScreenshot", true);
        capability.setCapability("acceptSslCerts", true);
        if (webDriverConfig.getBrowserVersion() != null) {
            capability.setVersion(webDriverConfig.getBrowserVersion());
        }
        if (webDriverConfig.getWebPlatform() != null) {
            capability.setPlatform(webDriverConfig.getWebPlatform());
        }
        if (webDriverConfig.getProxyHost() != null) {
            Proxy proxy = webDriverConfig.getProxy();
            capability.setCapability("proxy", (Object)proxy);
        }
        return capability;
    }
}

