/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.XMLConstants;
import com.seleniumtests.xmldog.XNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class NodeDescription
implements XMLConstants {
    protected static String DOCUMENT_NODE_DESCRIPTION = "Document Node ";

    public static void appendNodeDetail(StringBuffer buf, XNode xNode) {
        NodeDescription.appendNodeDetail(buf, xNode.getNode(), true);
        buf.append(" at ").append(xNode.getXPath());
    }

    private static void appendNodeDetail(StringBuffer buf, Node aNode, boolean notRecursing) {
        if (aNode == null) {
            return;
        }
        if (notRecursing) {
            buf.append("<");
        }
        switch (aNode.getNodeType()) {
            case 2: {
                NodeDescription.appendAttributeDetail(buf, aNode);
                break;
            }
            case 1: {
                NodeDescription.appendElementDetail(buf, aNode, notRecursing);
                break;
            }
            case 3: {
                NodeDescription.appendTextDetail(buf, aNode);
                break;
            }
            case 4: {
                NodeDescription.appendCdataSectionDetail(buf, aNode);
                break;
            }
            case 8: {
                NodeDescription.appendCommentDetail(buf, aNode);
                break;
            }
            case 7: {
                NodeDescription.appendProcessingInstructionDetail(buf, aNode);
                break;
            }
            case 10: {
                NodeDescription.appendDocumentTypeDetail(buf, aNode);
                break;
            }
            case 9: {
                NodeDescription.appendDocumentDetail(buf);
                break;
            }
            default: {
                buf.append("!--NodeType ").append(aNode.getNodeType()).append(' ').append(aNode.getNodeName()).append('/').append(aNode.getNodeValue()).append("--");
            }
        }
        if (notRecursing) {
            buf.append(">");
        }
    }

    protected static void appendDocumentDetail(StringBuffer buf) {
        buf.append(DOCUMENT_NODE_DESCRIPTION).append("<").append("...").append(">");
    }

    protected static void appendDocumentTypeDetail(StringBuffer buf, Node aNode) {
        DocumentType type = (DocumentType)aNode;
        buf.append("!DOCTYPE ").append(type.getName());
        boolean hasNoPublicId = true;
        if (type.getPublicId() != null && type.getPublicId().length() > 0) {
            buf.append(" PUBLIC \"").append(type.getPublicId()).append('\"');
            hasNoPublicId = false;
        }
        if (type.getSystemId() != null && type.getSystemId().length() > 0) {
            if (hasNoPublicId) {
                buf.append(" SYSTEM");
            }
            buf.append(" \"").append(type.getSystemId()).append('\"');
        }
    }

    protected static void appendProcessingInstructionDetail(StringBuffer buf, Node aNode) {
        ProcessingInstruction instr = (ProcessingInstruction)aNode;
        buf.append("?").append(instr.getTarget()).append(' ').append(instr.getData()).append("?");
    }

    protected static void appendCommentDetail(StringBuffer buf, Node aNode) {
        buf.append("!--").append(aNode.getNodeValue()).append("--");
    }

    protected static void appendCdataSectionDetail(StringBuffer buf, Node aNode) {
        buf.append("![CDATA[").append(aNode.getNodeValue()).append("]]");
    }

    protected static void appendTextDetail(StringBuffer buf, Node aNode) {
        NodeDescription.appendNodeDetail(buf, aNode.getParentNode(), false);
        buf.append(" ...").append(">").append(aNode.getNodeValue()).append("</");
        NodeDescription.appendNodeDetail(buf, aNode.getParentNode(), false);
    }

    protected static void appendElementDetail(StringBuffer buf, Node aNode, boolean notRecursing) {
        buf.append(aNode.getNodeName());
        if (notRecursing) {
            buf.append("...");
        }
    }

    protected static void appendAttributeDetail(StringBuffer buf, Node aNode) {
        NodeDescription.appendNodeDetail(buf, ((Attr)aNode).getOwnerElement(), false);
        buf.append(' ').append(aNode.getNodeName()).append("=\"").append(aNode.getNodeValue()).append("\"...");
    }
}

