/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.MOVMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrderedMap
implements Serializable {
    public static final int TYPE_SYNCHRONIZED = 1;
    public static final int TYPE_UNSYNCHRONIZED = 2;
    public static final int TYPE_UNSYNCHRONIZED_MOV = 3;
    private List _elementOrder = null;
    private Map _elements = null;
    private int _type = -1;

    public OrderedMap(int type) {
        if (type == 1) {
            this._elementOrder = Collections.synchronizedList(new ArrayList());
            this._elements = Collections.synchronizedMap(new HashMap());
        } else if (type == 2) {
            this._elementOrder = new ArrayList();
            this._elements = new HashMap();
        } else if (type == 3) {
            this._elementOrder = new ArrayList();
            this._elements = new MOVMap();
        } else {
            throw new IllegalArgumentException("Unrecongnized OrderedMap type");
        }
    }

    public int size() {
        return this._elementOrder.size();
    }

    public void clear() {
        this._elementOrder.clear();
        this._elements.clear();
    }

    public int getType() {
        return this._type;
    }

    public boolean contains(Object element) {
        return this._elements.containsValue(element);
    }

    public boolean containsKey(Object eKey) {
        return this._elementOrder.contains(eKey);
    }

    public boolean containsElementKey(Object eKey) {
        return this._elementOrder.contains(eKey);
    }

    public List getElementOrder() {
        return this._elementOrder;
    }

    public Object getElement(Object elementKey) {
        if (elementKey != null) {
            return this._elements.get(elementKey);
        }
        return null;
    }

    public Object getElement(int position) {
        if (position > this._elementOrder.size() || position < 0) {
            return null;
        }
        Object elementKey = this._elementOrder.get(position);
        return this.getElement(elementKey);
    }

    public Object[] elements() {
        Object[] objects = new Object[this._elementOrder.size()];
        for (int i = 0; i < this._elementOrder.size(); ++i) {
            objects[i] = this._elements.get(this._elementOrder.get(i));
        }
        return objects;
    }

    public Iterator elementKeys() {
        return this._elementOrder.iterator();
    }

    public void add(Object eKey, Object element) {
        if (!this._elements.containsKey(eKey) && this.getType() != 3) {
            this._elementOrder.add(eKey);
        }
        this._elements.put(eKey, element);
    }

    public void insert(Object eKey, Object element, int position) {
        this._elementOrder.add(position, eKey);
        this._elements.put(eKey, element);
    }

    public int indexOf(Object eKey) {
        return this._elementOrder.indexOf(eKey);
    }
}

