/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import java.util.concurrent.atomic.AtomicInteger;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class TestRetryAnalyzer
implements IRetryAnalyzer {
    public static final int MAX_RETRY_COUNT = 3;
    private static final AtomicInteger count = new AtomicInteger(3);

    public static void resetCount() {
        count.set(3);
    }

    public int getCount() {
        return count.get();
    }

    private boolean isRetryAvailable() {
        return count.get() > 0;
    }

    public boolean retry(ITestResult result) {
        boolean retry = false;
        if (this.isRetryAvailable()) {
            System.out.println("Going to retry test case: " + result.getMethod() + ", " + (3 - count.get() + 1) + " out of " + 3);
            retry = true;
            count.decrementAndGet();
        }
        return retry;
    }
}

