/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.reporter;

import com.seleniumtests.core.SeleniumTestsPageListener;
import com.seleniumtests.reporter.pluginmodel.Method;
import com.seleniumtests.reporter.pluginmodel.Page;
import com.seleniumtests.reporter.pluginmodel.Plugin;
import com.seleniumtests.reporter.pluginmodel.SeleniumTestsPlugins;
import com.seleniumtests.reporter.pluginmodel.Test;
import com.seleniumtests.webelements.IPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class PluginsHelper {
    private static final Logger logger = Logger.getLogger(PluginsHelper.class);
    private static Map<String, SeleniumTestsPageListener> pageListenerMap = Collections.synchronizedMap(new HashMap());
    private static final PluginsHelper instance = new PluginsHelper();
    private SeleniumTestsPlugins _seleniumTestsPlugins = null;

    public static synchronized PluginsHelper getInstance() {
        return instance;
    }

    public List<SeleniumTestsPageListener> getPageListeners() {
        List<SeleniumTestsPageListener> tempPageListenerList = Collections.synchronizedList(new ArrayList());
        tempPageListenerList.addAll(pageListenerMap.values());
        return tempPageListenerList;
    }

    public void invokePageListeners(String testMethodSignature, IPage page, boolean isPageLoad) {
        if (this._seleniumTestsPlugins == null) {
            return;
        }
        ArrayList<SeleniumTestsPageListener> pageListenerList = new ArrayList<SeleniumTestsPageListener>();
        for (Plugin plugin : this._seleniumTestsPlugins.getPlugin()) {
            if (!this.isPageListenerApplicable(plugin, testMethodSignature, page.getClass().getCanonicalName())) continue;
            pageListenerList.add(pageListenerMap.get(plugin.getClassName().trim()));
        }
        for (SeleniumTestsPageListener listener : pageListenerList) {
            try {
                if (isPageLoad) {
                    listener.onPageLoad(page);
                    continue;
                }
                listener.onPageUnload(page);
            }
            catch (Throwable e) {
                logger.error((Object)e);
            }
        }
    }

    public boolean isPageListenerApplicable(Plugin plugin, String testMethodSignature, String pageClassName) {
        if (testMethodSignature == null) {
            return true;
        }
        boolean testFound = false;
        for (Test test : plugin.getTest()) {
            if (!testMethodSignature.matches(test.getClassName() + "\\.\\w.*")) continue;
            for (Page page : test.getPage()) {
                if (!pageClassName.matches(page.getClassName())) continue;
                testFound = true;
                break;
            }
            if (!testFound) continue;
            for (Method method : test.getMethod()) {
                if (!testMethodSignature.matches(test.getClassName() + "\\." + method.getName() + ".*")) continue;
                for (Page page : method.getPage()) {
                    if (!pageClassName.matches(page.getClassName())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isTestResultEffected(String pageListenerClassName) {
        SeleniumTestsPageListener listener = pageListenerMap.get(pageListenerClassName);
        if (listener != null) {
            return listener.isTestResultEffected();
        }
        return false;
    }

    public void loadPlugins(File path) {
        logger.info((Object)("Loading Selenium Tests Plugins from path: " + path + " ..."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
            JAXBContext jc = JAXBContext.newInstance((String)"com.seleniumtests.reporter.pluginmodel");
            Unmarshaller u = jc.createUnmarshaller();
            this._seleniumTestsPlugins = (SeleniumTestsPlugins)u.unmarshal((InputStream)is);
            for (Plugin plugin : this._seleniumTestsPlugins.getPlugin()) {
                try {
                    pageListenerMap.put(plugin.getClassName().trim(), (SeleniumTestsPageListener)Class.forName(plugin.getClassName().trim()).newInstance());
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to load Plugins.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

