/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.webelements;

import com.seleniumtests.core.CustomAssertion;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.customexception.NotCurrentPageException;
import com.seleniumtests.driver.WebUIDriver;
import com.seleniumtests.helper.WaitHelper;
import com.seleniumtests.webelements.HtmlElement;
import com.seleniumtests.webelements.Table;
import java.util.Set;
import java.util.function.Function;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.Assert;

public abstract class BasePage {
    protected WebDriver driver = WebUIDriver.getWebDriver();
    protected final WebUIDriver webUXDriver = WebUIDriver.getWebUIDriver();
    private static final int EXPLICT_WAIT_TIMEOUT = WebUIDriver.getWebUIDriver().getExplicitWait();
    private final int sessionTimeout = WebUIDriver.getWebUIDriver().getWebSessionTimeout();

    public void acceptAlert() throws NotCurrentPageException {
        Alert alert = this.driver.switchTo().alert();
        alert.accept();
        this.driver.switchTo().defaultContent();
    }

    public void assertAlertPresent() {
        TestLogging.logWebStep("assert alert present.", false);
        try {
            this.driver.switchTo().alert();
        }
        catch (Exception ex) {
            this.assertAlertHTML(false, "assert alert present.");
        }
    }

    public void assertAlertText(String text) {
        TestLogging.logWebStep("assert alert text.", false);
        Alert alert = this.driver.switchTo().alert();
        String alertText = alert.getText();
        this.assertAlertHTML(alertText.contains(text), "assert alert text.");
    }

    public void assertAttribute(HtmlElement element, String attributeName, String value) {
        TestLogging.logWebStep("assert " + element.toHTML() + " attribute = " + attributeName + ", expectedValue ={" + value + "}.", false);
        String attributeValue = element.getAttribute(attributeName);
        this.assertHTML(value != null && value.equals(attributeValue), element.toString() + " attribute = " + attributeName + ", expectedValue = {" + value + "}, attributeValue = {" + attributeValue + "}");
    }

    public void assertAttributeContains(HtmlElement element, String attributeName, String keyword) {
        TestLogging.logWebStep("assert " + element.toHTML() + " attribute=" + attributeName + ", contains keyword = {" + keyword + "}.", false);
        String attributeValue = element.getAttribute(attributeName);
        this.assertHTML(attributeValue != null && keyword != null && attributeValue.contains(keyword), element.toString() + " attribute=" + attributeName + ", expected to contains keyword {" + keyword + "}, attributeValue = {" + attributeValue + "}");
    }

    public void assertAttributeMatches(HtmlElement element, String attributeName, String regex) {
        TestLogging.logWebStep("assert " + element.toHTML() + " attribute=" + attributeName + ", matches regex = {" + regex + "}.", false);
        String attributeValue = element.getAttribute(attributeName);
        this.assertHTML(attributeValue != null && regex != null && attributeValue.matches(regex), element.toString() + " attribute=" + attributeName + " expected to match regex {" + regex + "}, attributeValue = {" + attributeValue + "}");
    }

    public void assertConfirmationText(String text) {
        TestLogging.logWebStep("assert confirmation text.", false);
        Alert alert = this.driver.switchTo().alert();
        String seenText = alert.getText();
        this.assertAlertHTML(seenText.contains(text), "assert confirmation text.");
    }

    protected void assertCurrentPage(boolean log) throws NotCurrentPageException {
    }

    public void assertElementNotPresent(HtmlElement element) {
        TestLogging.logWebStep("assert " + element.toHTML() + " is not present.", false);
        this.assertHTML(!element.isElementPresent(), element.toString() + " found.");
    }

    public void assertElementPresent(HtmlElement element) {
        TestLogging.logWebStep("assert " + element.toHTML() + " is present.", false);
        this.assertHTML(element.isElementPresent(), element.toString() + " not found.");
    }

    public void assertElementEnabled(HtmlElement element) {
        TestLogging.logWebStep("assert " + element.toHTML() + " is enabled.", false);
        this.assertHTML(element.isEnabled(), element.toString() + " not found.");
    }

    public void assertElementNotEnabled(HtmlElement element) {
        TestLogging.logWebStep("assert " + element.toHTML() + " is not enabled.", false);
        this.assertHTML(!element.isEnabled(), element.toString() + " not found.");
    }

    public void assertElementDisplayed(HtmlElement element) {
        TestLogging.logWebStep("assert " + element.toHTML() + " is displayed.", false);
        this.assertHTML(element.isDisplayed(), element.toString() + " not found.");
    }

    public void assertElementSelected(HtmlElement element) {
        TestLogging.logWebStep("assert " + element.toHTML() + " is selected.", false);
        this.assertHTML(element.isSelected(), element.toString() + " not found.");
    }

    public void assertElementNotSelected(HtmlElement element) {
        TestLogging.logWebStep("assert " + element.toHTML() + " is NOT selected.", false);
        this.assertHTML(!element.isSelected(), element.toString() + " not found.");
    }

    public void assertCondition(boolean condition, String message) {
        TestLogging.logWebStep("assert that " + message, false);
        assert (condition);
    }

    void assertHTML(boolean condition, String message) {
        if (!condition) {
            this.capturePageSnapshot();
            CustomAssertion.assertTrue(condition, message);
        }
    }

    void assertAlertHTML(boolean condition, String message) {
        if (!condition) {
            CustomAssertion.assertTrue(condition, message);
        }
    }

    public void assertPromptText(String text) {
        TestLogging.logWebStep("assert prompt text.", false);
        Alert alert = this.driver.switchTo().alert();
        String seenText = alert.getText();
        this.assertAlertHTML(seenText.contains(text), "assert prompt text.");
    }

    public void assertTable(Table table, int row, int col, String text) {
        TestLogging.logWebStep("assert text \"" + text + "\" equals " + table.toHTML() + " at (row, col) = (" + row + ", " + col + ").", false);
        String content = table.getContent(row, col);
        this.assertHTML(content != null && content.equals(text), "Text= {" + text + "} not found on " + table.toString() + " at cell(row, col) = {" + row + "," + col + "}");
    }

    public void assertTableContains(Table table, int row, int col, String text) {
        TestLogging.logWebStep("assert text \"" + text + "\" contains " + table.toHTML() + " at (row, col) = (" + row + ", " + col + ").", false);
        String content = table.getContent(row, col);
        this.assertHTML(content != null && content.contains(text), "Text= {" + text + "} not found on " + table.toString() + " at cell(row, col) = {" + row + "," + col + "}");
    }

    public void assertTableMatches(Table table, int row, int col, String text) {
        TestLogging.logWebStep("assert text \"" + text + "\" matches " + table.toHTML() + " at (row, col) = (" + row + ", " + col + ").", false);
        String content = table.getContent(row, col);
        this.assertHTML(content != null && content.matches(text), "Text= {" + text + "} not found on " + table.toString() + " at cell(row, col) = {" + row + "," + col + "}");
    }

    public void assertTextNotPresent(String text) {
        TestLogging.logWebStep("assert text \"" + text + "\" is not present.", false);
        this.assertHTML(!BasePage.isTextPresent(text), "Text= {" + text + "} found.");
    }

    public void assertTextNotPresentIgnoreCase(String text) {
        TestLogging.logWebStep("assert text \"" + text + "\" is not present.(ignore case)", false);
        this.assertHTML(!this.getBodyText().toLowerCase().contains(text.toLowerCase()), "Text= {" + text + "} found.");
    }

    public void assertTextPresent(String text) {
        TestLogging.logWebStep("assert text \"" + text + "\" is present.", false);
        this.assertHTML(BasePage.isTextPresent(text), "Text= {" + text + "} not found.");
    }

    public void assertTextPresentIgnoreCase(String text) {
        TestLogging.logWebStep("assert text \"" + text + "\" is present.(ignore case)", false);
        this.assertHTML(this.getBodyText().toLowerCase().contains(text.toLowerCase()), "Text= {" + text + "} not found.");
    }

    public String cancelConfirmation() throws NotCurrentPageException {
        Alert alert = this.driver.switchTo().alert();
        String seenText = alert.getText();
        alert.dismiss();
        this.driver.switchTo().defaultContent();
        return seenText;
    }

    protected abstract void capturePageSnapshot();

    public Alert getAlert() {
        Alert alert = this.driver.switchTo().alert();
        return alert;
    }

    public String getAlertText() {
        Alert alert = this.driver.switchTo().alert();
        String seenText = alert.getText();
        return seenText;
    }

    private String getBodyText() {
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        return body.getText();
    }

    public String getConfirmation() {
        Alert alert = this.driver.switchTo().alert();
        String seenText = alert.getText();
        return seenText;
    }

    public WebDriver getDriver() {
        this.driver = WebUIDriver.getWebDriver();
        return this.driver;
    }

    public String getPrompt() {
        Alert alert = this.driver.switchTo().alert();
        String seenText = alert.getText();
        return seenText;
    }

    public boolean isElementPresent(By by) {
        int count = 0;
        try {
            count = WebUIDriver.getWebDriver().findElements(by).size();
        }
        catch (RuntimeException e) {
            if (e instanceof InvalidSelectorException || e.getMessage() != null && e.getMessage().contains("TransformedEntriesMap cannot be cast to java.util.List")) {
                TestLogging.log("InvalidSelectorException or CastException got, retry");
                WaitHelper.waitForSeconds(2);
                count = WebUIDriver.getWebDriver().findElements(by).size();
            }
            throw e;
        }
        return count != 0;
    }

    public boolean isFrame() {
        return false;
    }

    public static boolean isTextPresent(String text) {
        CustomAssertion.assertNotNull(text, "isTextPresent: text should not be null!");
        WebElement body = WebUIDriver.getWebDriver().findElement(By.tagName((String)"body"));
        return body.getText().contains(text);
    }

    public void selectFrame(By by) {
        TestLogging.logWebStep("select frame, locator={\"" + by.toString() + "\"}", false);
        this.driver.switchTo().frame(this.driver.findElement(by));
    }

    public final void selectWindow(String windowName) throws NotCurrentPageException {
        if (windowName == null) {
            try {
                this.driver.switchTo().window(windowName);
            }
            catch (Exception e) {
                this.driver.switchTo().defaultContent();
            }
        }
    }

    public void refreshPageTillTextAppears(String text, int waitPeriodInSec) throws InterruptedException {
        for (int i = 0; i <= waitPeriodInSec && !this.driver.getPageSource().contains(text); ++i) {
            Thread.sleep(1000L);
            this.driver.navigate().refresh();
        }
    }

    public void waitForElementChecked(HtmlElement element) {
        Assert.assertNotNull((Object)element, (String)"Element can't be null");
        TestLogging.logWebStep("wait for " + element.toString() + " to be checked.", false);
        WebDriverWait wait = new WebDriverWait(this.driver, (long)EXPLICT_WAIT_TIMEOUT);
        wait.until((Function)ExpectedConditions.elementToBeSelected((By)element.getBy()));
    }

    public void waitForElementEditable(HtmlElement element) {
        Assert.assertNotNull((Object)element, (String)"Element can't be null");
        TestLogging.logWebStep("wait for " + element.toString() + " to be editable.", false);
        WebDriverWait wait = new WebDriverWait(this.driver, (long)EXPLICT_WAIT_TIMEOUT);
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)element.getBy()));
    }

    public void waitForElementPresent(By by) {
        TestLogging.logWebStep("wait for " + by.toString() + " to be present.", false);
        WebDriverWait wait = new WebDriverWait(this.driver, (long)EXPLICT_WAIT_TIMEOUT);
        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)by));
    }

    public void waitForElementPresent(By by, int timeout) {
        TestLogging.logWebStep("wait for " + by.toString() + " to be present.", false);
        WebDriverWait wait = new WebDriverWait(this.driver, (long)timeout);
        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)by));
    }

    public void waitForElementPresent(HtmlElement element) {
        Assert.assertNotNull((Object)element, (String)"Element can't be null");
        TestLogging.logWebStep("wait for " + element.toString() + " to be present.", false);
        WebDriverWait wait = new WebDriverWait(this.driver, (long)EXPLICT_WAIT_TIMEOUT);
        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)element.getBy()));
    }

    public static void waitForElementToBeVisible(HtmlElement element) {
        Assert.assertNotNull((Object)element, (String)"Element can't be null");
        TestLogging.logWebStep("wait for " + element.toString() + " to be visible.", false);
        WebDriverWait wait = new WebDriverWait(WebUIDriver.getWebDriver(), (long)EXPLICT_WAIT_TIMEOUT);
        wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)element.getBy()));
    }

    public static void waitForURLToChange(String match, int waitSeconds, boolean partialMatch) {
        for (int i = 0; i < waitSeconds; ++i) {
            if (partialMatch) {
                if (WebUIDriver.getWebDriver().getCurrentUrl().contains(match)) break;
                WaitHelper.waitForSeconds(1);
                continue;
            }
            if (WebUIDriver.getWebDriver().getCurrentUrl().equals(match)) break;
            WaitHelper.waitForSeconds(1);
        }
    }

    public static void switchToWindow(Set<String> allWindows, String currentWindow) {
        for (String window : allWindows) {
            if (window.equals(currentWindow)) continue;
            WebUIDriver.getWebDriver().switchTo().window(window);
        }
    }

    public static void waitForElementToDisappear(HtmlElement element) {
        Assert.assertNotNull((Object)element, (String)"Element can't be null");
        TestLogging.logWebStep("wait for " + element.toString() + " to disappear.", false);
        WebDriverWait wait = new WebDriverWait(WebUIDriver.getWebDriver(), (long)EXPLICT_WAIT_TIMEOUT);
        wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)element.getBy()));
    }

    protected void waitForSeconds(int seconds) {
        WaitHelper.waitForSeconds(seconds);
    }

    public void waitForTextPresent(HtmlElement element, String text) {
        Assert.assertNotNull((Object)text, (String)"Text can't be null");
        TestLogging.logWebStep("wait for text \"" + text + "\" to be present.", false);
        WebDriverWait wait = new WebDriverWait(this.driver, (long)EXPLICT_WAIT_TIMEOUT);
        wait.until((Function)ExpectedConditions.textToBePresentInElement((By)element.getBy(), (String)text));
    }

    public void waitForTextPresent(String text) {
        Assert.assertNotNull((Object)text, (String)"Text can't be null");
        TestLogging.logWebStep("wait for text \"" + text + "\" to be present.", false);
        boolean b = false;
        for (int millisec = 0; millisec < EXPLICT_WAIT_TIMEOUT * 1000; millisec += 1000) {
            try {
                if (BasePage.isTextPresent(text)) {
                    b = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.assertHTML(b, "Timed out waiting for text \"" + text + "\" to be there.");
    }

    public void waitForTextToDisappear(String text) {
        Assert.assertNotNull((Object)text, (String)"Text can't be null");
        TestLogging.logWebStep("wait for text \"" + text + "\" to disappear.", false);
        boolean textPresent = true;
        for (int millisec = 0; millisec < EXPLICT_WAIT_TIMEOUT * 1000; millisec += 1000) {
            try {
                if (!BasePage.isTextPresent(text)) {
                    textPresent = false;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.assertHTML(!textPresent, "Timed out waiting for text \"" + text + "\" to be gone.");
    }

    public void waitForTextToDisappear(String text, int explicitWaitTimeout) {
        Assert.assertNotNull((Object)text, (String)"Text can't be null");
        TestLogging.logWebStep("wait for text \"" + text + "\" to disappear.", false);
        boolean textPresent = true;
        for (int millisec = 0; millisec < explicitWaitTimeout * 1000; millisec += 1000) {
            try {
                if (!BasePage.isTextPresent(text)) {
                    textPresent = false;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.assertHTML(!textPresent, "Timed out waiting for text \"" + text + "\" to be gone.");
    }

    public void waitForURLToBeginWith(String regex, int waitCount) throws InterruptedException {
        for (int i = 0; i < waitCount && !this.getDriver().getCurrentUrl().matches(regex); ++i) {
            Thread.sleep(1000L);
        }
    }
}

