/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.customFFprofile.FireFoxProfileMarker;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.DriverMode;
import com.seleniumtests.helper.FileUtility;
import com.seleniumtests.helper.OSUtility;
import com.seleniumtests.resources.WebDriverExternalResources;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxCapabilitiesFactory
implements ICapabilitiesFactory {
    private static boolean isProfileCreated = false;
    private static Object lockProfile = new Object();

    protected void configProfile(FirefoxProfile profile, DriverConfig webDriverConfig) {
        profile.setAcceptUntrustedCertificates(webDriverConfig.isSetAcceptUntrustedCertificates());
        profile.setAssumeUntrustedCertificateIssuer(webDriverConfig.isSetAssumeUntrustedCertificateIssuer());
        if (webDriverConfig.getFirefoxBinPath() != null) {
            System.setProperty("webdriver.firefox.bin", webDriverConfig.getFirefoxBinPath());
        }
        if (webDriverConfig.getUserAgentOverride() != null) {
            profile.setPreference("general.useragent.override", webDriverConfig.getUserAgentOverride());
        }
        if (webDriverConfig.getNtlmAuthTrustedUris() != null) {
            profile.setPreference("network.automatic-ntlm-auth.trusted-uris", webDriverConfig.getNtlmAuthTrustedUris());
        }
        if (webDriverConfig.getBrowserDownloadDir() != null) {
            profile.setPreference("browser.download.dir", webDriverConfig.getBrowserDownloadDir());
            profile.setPreference("browser.download.folderList", 2);
            profile.setPreference("browser.download.manager.showWhenStarting", false);
            profile.setPreference("browser.helperApps.neverAsk.saveToDisk", "application/octet-stream,text/plain,application/pdf,application/zip,text/csv,text/html");
        }
        if (!webDriverConfig.isEnableJavascript()) {
            profile.setPreference("javascript.enabled", false);
        }
        profile.setPreference("capability.policy.default.Window.QueryInterface", "allAccess");
        profile.setPreference("capability.policy.default.Window.frameElement.get", "allAccess");
        profile.setPreference("capability.policy.default.HTMLDocument.compatMode.get", "allAccess");
        profile.setPreference("capability.policy.default.Document.compatMode.get", "allAccess");
        profile.setPreference("dom.max_chrome_script_run_time", 0);
        profile.setPreference("dom.max_script_run_time", 0);
    }

    @Override
    public DesiredCapabilities createCapabilities(DriverConfig webDriverConfig) {
        DesiredCapabilities capability;
        block11: {
            capability = new DesiredCapabilities();
            capability.setBrowserName(DesiredCapabilities.firefox().getBrowserName());
            FirefoxProfile profile = this.getFirefoxProfile(webDriverConfig);
            this.configProfile(profile, webDriverConfig);
            capability.setCapability("firefox_profile", (Object)profile);
            if (webDriverConfig.isEnableJavascript()) {
                capability.setJavascriptEnabled(true);
            } else {
                capability.setJavascriptEnabled(false);
            }
            capability.setCapability("takesScreenshot", true);
            capability.setCapability("acceptSslCerts", true);
            if (webDriverConfig.getBrowserVersion() != null) {
                capability.setVersion(webDriverConfig.getBrowserVersion());
            }
            if (webDriverConfig.getWebPlatform() != null) {
                capability.setPlatform(webDriverConfig.getWebPlatform());
            }
            if (webDriverConfig.getProxyHost() != null) {
                capability.setCapability("proxy", (Object)webDriverConfig.getProxy());
            }
            if (webDriverConfig.getMode() == DriverMode.LOCAL) {
                String firefoxDriverPath = webDriverConfig.getChromeDriverPath();
                if (firefoxDriverPath == null) {
                    try {
                        if (System.getenv("webdriver.gecko.driver") != null) {
                            System.out.println("get gecko driver from property:" + System.getenv("webdriver.gecko.driver"));
                            System.setProperty("webdriver.gecko.driver", System.getenv("webdriver.gecko.driver"));
                            break block11;
                        }
                        this.handleExtractResources();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    System.setProperty("webdriver.gecko.driver", firefoxDriverPath);
                }
            }
        }
        return capability;
    }

    public void handleExtractResources() throws IOException {
        String dir = this.getClass().getResource("/").getPath();
        if (!new File(dir = FileUtility.decodePath(dir)).exists()) {
            System.out.println("extracting marionette resources in " + dir);
            FileUtility.extractJar(dir, WebDriverExternalResources.class);
        }
        if (!new File(dir + OSUtility.getSlash() + "geckodriver.exe").exists()) {
            FileUtility.extractJar(dir, WebDriverExternalResources.class);
        }
        if (OSUtility.isWindows()) {
            System.setProperty("webdriver.gecko.driver", dir + "\\geckodriver.exe");
        } else if (OSUtility.isMac()) {
            System.setProperty("webdriver.gecko.driver", dir + "/mac/geckodriver");
        } else {
            System.setProperty("webdriver.gecko.driver", dir + "/geckodriver");
        }
    }

    protected FirefoxProfile createFirefoxProfile(String path) {
        if (path != null) {
            return new FirefoxProfile(new File(path));
        }
        return new FirefoxProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractDefaultProfile(String profilePath) throws IOException {
        Object object = lockProfile;
        synchronized (object) {
            try {
                if (!isProfileCreated) {
                    System.out.println("start create profile");
                    FileUtility.deleteDirectory(profilePath);
                    FileUtility.extractJar(profilePath, FireFoxProfileMarker.class);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        isProfileCreated = true;
    }

    protected synchronized FirefoxProfile getFirefoxProfile(DriverConfig webDriverConfig) {
        String path = webDriverConfig.getFirefoxProfilePath();
        String realPath = webDriverConfig.isUseFirefoxDefaultProfile() ? this.getFirefoxProfilePath(path) : null;
        FirefoxProfile profile = this.createFirefoxProfile(realPath);
        return profile;
    }

    protected String getFirefoxProfilePath(String path) {
        String realPath = null;
        if (path != null && !new File(path).exists()) {
            TestLogging.log("Firefox profile path:" + path + " not found, use default");
            path = null;
        }
        if (path != null) {
            realPath = path;
        } else {
            try {
                String profilePath = this.getClass().getResource("/").getPath() + "ffprofile";
                profilePath = FileUtility.decodePath(profilePath);
                this.extractDefaultProfile(profilePath);
                realPath = profilePath + OSUtility.getSlash() + "customFFprofile";
            }
            catch (Exception e) {
                e.printStackTrace();
                realPath = null;
            }
        }
        System.out.println("Firefox Profile: " + realPath);
        return realPath;
    }
}

