/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.AndroidCapabilitiesFactory;
import com.seleniumtests.browserfactory.ChromeCapabilitiesFactory;
import com.seleniumtests.browserfactory.FirefoxCapabilitiesFactory;
import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.browserfactory.IECapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.browserfactory.SafariCapabilitiesFactory;
import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.BrowserType;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.ScreenShotRemoteWebDriver;
import com.seleniumtests.helper.WaitHelper;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    public RemoteDriverFactory(DriverConfig cfg) {
        super(cfg);
    }

    @Override
    public WebDriver createWebDriver() throws MalformedURLException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        DriverConfig webDriverConfig = this.getWebDriverConfig();
        DesiredCapabilities capability = null;
        URL url = new URL(webDriverConfig.getHubUrl());
        switch (webDriverConfig.getBrowser()) {
            case FireFox: {
                capability = new FirefoxCapabilitiesFactory().createCapabilities(webDriverConfig);
                break;
            }
            case InternetExplore: {
                capability = new IECapabilitiesFactory().createCapabilities(webDriverConfig);
                break;
            }
            case Chrome: {
                capability = new ChromeCapabilitiesFactory().createCapabilities(webDriverConfig);
                break;
            }
            case Safari: {
                capability = new SafariCapabilitiesFactory().createCapabilities(webDriverConfig);
                break;
            }
            case Android: {
                capability = new AndroidCapabilitiesFactory().createCapabilities(webDriverConfig);
                break;
            }
            case IPhone: {
                capability = ((ICapabilitiesFactory)Class.forName("com.seleniumtests.browserfactory.IPhoneCapabilitiesFactory").getConstructor(new Class[0]).newInstance(new Object[0])).createCapabilities(webDriverConfig);
                break;
            }
        }
        switch (webDriverConfig.getBrowser()) {
            case FireFox: 
            case IPhone: {
                try {
                    this.driver = new ScreenShotRemoteWebDriver(url, capability);
                    break;
                }
                catch (RuntimeException e) {
                    if (e.getMessage().contains("Unable to connect to host 127.0.0.1 on port 7062 after 45000 ms. Firefox console output")) {
                        TestLogging.log("Firefox Driver creation got port customexception, retry after 5 seconds");
                        WaitHelper.waitForSeconds(5);
                        this.driver = new ScreenShotRemoteWebDriver(url, capability);
                        break;
                    }
                    throw e;
                }
            }
            default: {
                this.driver = new ScreenShotRemoteWebDriver(url, capability);
            }
        }
        this.setImplicitWaitTimeout(webDriverConfig.getImplicitWaitTimeout());
        if (webDriverConfig.getPageLoadTimeout() >= 0) {
            this.setPageLoadTimeout(webDriverConfig.getPageLoadTimeout(), webDriverConfig.getBrowser());
        }
        this.setWebDriver(this.driver);
        String hub = url.getHost();
        int port = url.getPort();
        try {
            HttpHost host = new HttpHost(hub, port);
            DefaultHttpClient client = new DefaultHttpClient();
            String sessionUrl = "http://" + hub + ":" + port + "/grid/api/testsession?session=";
            URL session = new URL(sessionUrl + ((RemoteWebDriver)this.driver).getSessionId());
            BasicHttpEntityEnclosingRequest req = new BasicHttpEntityEnclosingRequest("POST", session.toExternalForm());
            CloseableHttpResponse response = client.execute(host, (HttpRequest)req);
            String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            try {
                JSONObject object = new JSONObject(responseContent);
                String proxyId = (String)object.get("proxyId");
                String node = proxyId.split("//")[1].split(":")[0];
                String browserName = ((RemoteWebDriver)this.driver).getCapabilities().getBrowserName();
                String version = ((RemoteWebDriver)this.driver).getCapabilities().getVersion();
                System.out.println("WebDriver is running on node " + node + ", " + browserName + version + ", session " + ((RemoteWebDriver)this.driver).getSessionId());
                TestLogging.log("WebDriver is running on node " + node + ", " + browserName + version + ", session " + ((RemoteWebDriver)this.driver).getSessionId());
            }
            catch (JSONException jSONException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.driver;
    }

    protected void setPageLoadTimeout(long timeout, BrowserType type) {
        switch (type) {
            case Chrome: {
                try {
                    this.driver.manage().timeouts().pageLoadTimeout(timeout, TimeUnit.SECONDS);
                }
                catch (UnsupportedCommandException e) {
                    e.printStackTrace();
                }
                break;
            }
            case FireFox: 
            case InternetExplore: {
                this.driver.manage().timeouts().pageLoadTimeout(timeout, TimeUnit.SECONDS);
                break;
            }
        }
    }
}

