/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.webelements;

import com.seleniumtests.core.TestLogging;
import com.seleniumtests.driver.BrowserType;
import com.seleniumtests.driver.ScreenshotUtil;
import com.seleniumtests.driver.WebUIDriver;
import com.seleniumtests.helper.ContextHelper;
import com.seleniumtests.helper.WaitHelper;
import java.util.List;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class HtmlElement {
    private static final int EXPLICIT_WAIT_TIME_OUT = WebUIDriver.getWebUIDriver().getExplicitWait();
    protected static final Logger logger = TestLogging.getLogger(HtmlElement.class);
    protected WebDriver driver = WebUIDriver.getWebDriver();
    protected WebUIDriver webUXDriver = WebUIDriver.getWebUIDriver();
    protected WebElement element = null;
    private String label = null;
    private String locator = null;
    private By by = null;

    public HtmlElement(String label, By by) {
        this.label = label;
        this.by = by;
    }

    public HtmlElement(String label, String locator, LocatorType locatorType) {
        this.label = label;
        this.locator = locator;
        this.by = this.getLocatorBy(locator, locatorType);
    }

    public void captureSnapshot() {
        this.captureSnapshot(ContextHelper.getCallerMethod() + " on ");
    }

    protected void captureSnapshot(String messagePrefix) {
        ScreenshotUtil.captureSnapshot(messagePrefix);
    }

    public void click() {
        this.findElement();
        this.element.click();
    }

    public void clickAt() {
        this.clickAt("1,1");
    }

    public void clickAt(String value) {
        TestLogging.logWebStep("click on " + this.toHTML(), false);
        this.findElement();
        String[] parts = value.split(",");
        int xOffset = Integer.parseInt(parts[0]);
        int yOffset = Integer.parseInt(parts[1]);
        try {
            new Actions(this.driver).moveToElement(this.element, xOffset, yOffset).click().perform();
        }
        catch (InvalidElementStateException e) {
            e.printStackTrace();
            this.element.click();
        }
        try {
            BrowserType type = WebUIDriver.getWebUIDriver().getConfig().getBrowser();
            if ((type == BrowserType.Chrome || type == BrowserType.InternetExplore) && this.getDriver().switchTo().alert().getText().contains("leave")) {
                this.getDriver().switchTo().alert().accept();
            }
        }
        catch (NoAlertPresentException e) {
            e.printStackTrace();
        }
    }

    public void simulateClick() {
        this.findElement();
        String mouseOverScript = "if(document.createEvent){var evObj = document.createEvent('MouseEvents');evObj.initEvent('mouseover', true, false); arguments[0].dispatchEvent(evObj);} else if(document.createEventObject) { arguments[0].fireEvent('onmouseover');}";
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        js.executeScript("if(document.createEvent){var evObj = document.createEvent('MouseEvents');evObj.initEvent('mouseover', true, false); arguments[0].dispatchEvent(evObj);} else if(document.createEventObject) { arguments[0].fireEvent('onmouseover');}", new Object[]{this.element});
        WaitHelper.waitForSeconds(2);
        String clickScript = "if(document.createEvent){var evObj = document.createEvent('MouseEvents');evObj.initEvent('click', true, false); arguments[0].dispatchEvent(evObj);} else if(document.createEventObject) { arguments[0].fireEvent('onclick');}";
        js.executeScript("if(document.createEvent){var evObj = document.createEvent('MouseEvents');evObj.initEvent('click', true, false); arguments[0].dispatchEvent(evObj);} else if(document.createEventObject) { arguments[0].fireEvent('onclick');}", new Object[]{this.element});
        WaitHelper.waitForSeconds(2);
    }

    public void simulateMoveToElement(int x, int y) {
        this.findElement();
        ((JavascriptExecutor)this.driver).executeScript("function simulate(f,c,d,e){var b,a=null;for(b in eventMatchers)if(eventMatchers[b].test(c)){a=b;break}if(!a)return!1;document.createEvent?(b=document.createEvent(a),a==\"HTMLEvents\"?b.initEvent(c,!0,!0):b.initMouseEvent(c,!0,!0,document.defaultView,0,d,e,d,e,!1,!1,!1,!1,0,null),f.dispatchEvent(b)):(a=document.createEventObject(),a.detail=0,a.screenX=d,a.screenY=e,a.clientX=d,a.clientY=e,a.ctrlKey=!1,a.altKey=!1,a.shiftKey=!1,a.metaKey=!1,a.button=1,f.fireEvent(\"on\"+c,a));return!0} var eventMatchers={HTMLEvents:/^(?:load|unload|abort|errorLogger|select|change|submit|reset|focus|blur|resize|scroll)$/,MouseEvents:/^(?:click|dblclick|mouse(?:down|up|over|move|out))$/}; simulate(arguments[0],\"mousemove\",arguments[1],arguments[2]);", new Object[]{this.element, x, y});
    }

    protected void findElement() {
        this.driver = WebUIDriver.getWebDriver();
        this.element = this.driver.findElement(this.by);
    }

    public List<WebElement> getAllElements() {
        this.findElement();
        return this.driver.findElements(this.by);
    }

    public String getAttribute(String name) {
        this.findElement();
        return this.element.getAttribute(name);
    }

    public By getBy() {
        return this.by;
    }

    public String getCssValue(String propertyName) {
        this.findElement();
        return this.element.getCssValue(propertyName);
    }

    protected WebDriver getDriver() {
        return WebUIDriver.getWebDriver();
    }

    public WebElement getElement() {
        this.element = this.driver.findElement(this.by);
        return this.element;
    }

    public String getEval(String script) {
        this.findElement();
        String name = (String)((JavascriptExecutor)this.driver).executeScript(script, new Object[]{this.element});
        return name;
    }

    public int getHeight() {
        this.findElement();
        return this.element.getSize().getHeight();
    }

    public String getLabel() {
        return this.label;
    }

    public Point getLocation() {
        this.findElement();
        return this.element.getLocation();
    }

    public String getLocator() {
        return this.locator;
    }

    private By getLocatorBy(String locator, LocatorType locatorType) {
        switch (locatorType) {
            case ID: {
                return By.id((String)locator);
            }
            case NAME: {
                return By.name((String)locator);
            }
            case CLASS_NAME: {
                return By.className((String)locator);
            }
            case LINK_TEXT: {
                return By.linkText((String)locator);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)locator);
            }
            case CSS_SELECTOR: {
                return By.cssSelector((String)locator);
            }
            case TAG_NAME: {
                return By.tagName((String)locator);
            }
        }
        return By.xpath((String)locator);
    }

    public Dimension getSize() {
        this.findElement();
        return this.element.getSize();
    }

    public String getTagName() {
        this.findElement();
        return this.element.getTagName();
    }

    public String getText() {
        this.findElement();
        return this.element.getText();
    }

    public String getValue() {
        this.findElement();
        return this.element.getAttribute("value");
    }

    public int getWidth() {
        this.findElement();
        return this.element.getSize().getWidth();
    }

    public void init() {
        this.driver = WebUIDriver.getWebDriver();
        this.element = this.driver.findElement(this.by);
    }

    public boolean isDisplayed() {
        try {
            this.findElement();
            return this.element.isDisplayed();
        }
        catch (StaleElementReferenceException e) {
            this.findElement();
            return this.element.isDisplayed();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isElementPresent() {
        if (WebUIDriver.getWebDriver() == null) {
            TestLogging.log("Web Driver is terminated! Exception might caught in last action.");
            throw new RuntimeException("Web Driver is terminated! Exception might caught in last action.");
        }
        int count = 0;
        try {
            count = WebUIDriver.getWebDriver().findElements(this.by).size();
        }
        catch (RuntimeException e) {
            if (e instanceof InvalidSelectorException) {
                TestLogging.log("Got InvalidSelectorException, retry");
                WaitHelper.waitForSeconds(2);
                count = WebUIDriver.getWebDriver().findElements(this.by).size();
            }
            if (e.getMessage() != null && e.getMessage().contains("TransformedEntriesMap cannot be cast to java.util.List")) {
                TestLogging.log("Got CastException, retry");
                WaitHelper.waitForSeconds(2);
                count = WebUIDriver.getWebDriver().findElements(this.by).size();
            }
            throw e;
        }
        return count != 0;
    }

    public boolean isEnabled() {
        this.findElement();
        return this.element.isEnabled();
    }

    public boolean isSelected() {
        this.findElement();
        return this.element.isSelected();
    }

    public boolean isTextPresent(String text) {
        this.findElement();
        return this.element.getText().contains(text);
    }

    public void mouseDown() {
        TestLogging.log("MouseDown " + this.toString());
        this.findElement();
        Mouse mouse = ((HasInputDevices)this.driver).getMouse();
        mouse.mouseDown(null);
    }

    public void mouseOver() {
        TestLogging.log("MouseOver " + this.toString());
        this.findElement();
        Locatable hoverItem = (Locatable)this.element;
        Mouse mouse = ((HasInputDevices)this.driver).getMouse();
        mouse.mouseMove(hoverItem.getCoordinates());
    }

    public void simulateMouseOver() {
        this.findElement();
        String mouseOverScript = "if(document.createEvent){var evObj = document.createEvent('MouseEvents');evObj.initEvent('mouseover', true, false); arguments[0].dispatchEvent(evObj);} else if(document.createEventObject) { arguments[0].fireEvent('onmouseover');}";
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        js.executeScript("if(document.createEvent){var evObj = document.createEvent('MouseEvents');evObj.initEvent('mouseover', true, false); arguments[0].dispatchEvent(evObj);} else if(document.createEventObject) { arguments[0].fireEvent('onmouseover');}", new Object[]{this.element});
    }

    public void mouseUp() {
        TestLogging.log("MouseUp " + this.toString());
        this.findElement();
        Mouse mouse = ((HasInputDevices)this.driver).getMouse();
        mouse.mouseUp(null);
    }

    public void sendKeys(CharSequence arg0) {
        this.findElement();
        this.element.sendKeys(new CharSequence[]{arg0});
    }

    protected void sleep(int waitTime) throws InterruptedException {
        Thread.sleep(waitTime);
    }

    public String toHTML() {
        return this.getClass().getSimpleName().toLowerCase() + " <a style=\"font-style:normal;color:#8C8984;text-decoration:none;\" href=# \">" + this.getLabel() + ",: " + this.getBy().toString() + "</a>";
    }

    public String toString() {
        return this.getClass().getSimpleName().toLowerCase() + " " + this.getLabel() + ", by={" + this.getBy().toString() + "}";
    }

    public void waitForPresent() {
        this.waitForPresent(EXPLICIT_WAIT_TIME_OUT);
    }

    public void waitForPresent(int timeout) {
        TestLogging.logWebStep("wait for " + this.toString() + " to present.", false);
        WebDriverWait wait = new WebDriverWait(this.driver, (long)timeout);
        wait.until((Function)new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                return driver.findElement(HtmlElement.this.by);
            }
        });
    }

    private static enum LocatorType {
        ID,
        NAME,
        CLASS_NAME,
        LINK_TEXT,
        PARTIAL_LINK_TEXT,
        CSS_SELECTOR,
        TAG_NAME,
        XPATH;

    }
}

