/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.reporter;

public class ElaborateLog {
    private String type;
    private String msg;
    private String screen;
    private String src;
    private String location;
    private String href;
    private String root;

    public ElaborateLog(String s, String root) {
        String[] parts;
        this.root = root;
        if (s == null) {
            return;
        }
        for (String part : parts = s.split("\\|\\|")) {
            this.parse(part);
        }
    }

    public String getHref() {
        return this.href;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMsg() {
        return this.msg;
    }

    private void parse(String part) {
        if (part.startsWith("TYPE=")) {
            this.type = part.replace("TYPE=", "");
        } else if (part.startsWith("MSG=")) {
            this.msg = part.replace("MSG=", "");
        } else if (part.startsWith("SCREEN=")) {
            this.screen = part.replace("SCREEN=", "");
        } else if (part.startsWith("SRC=")) {
            this.src = part.replace("SRC=", "");
        } else if (part.startsWith("LOCATION=")) {
            this.location = part.replace("LOCATION=", "");
        } else if (part.startsWith("HREF=")) {
            this.href = part.replace("HREF=", "");
        } else {
            this.msg = part;
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("TYPE=");
        if (this.type != null) {
            buff.append(this.type);
        }
        buff.append("||MSG=");
        if (this.msg != null) {
            buff.append(this.msg);
        }
        buff.append("||SCREEN=");
        if (this.screen != null) {
            buff.append(this.screen);
        }
        buff.append("||SRC=");
        if (this.src != null) {
            buff.append(this.src);
        }
        buff.append("||LOCATION=");
        if (this.location != null) {
            buff.append(this.location);
        }
        buff.append("||HREF=");
        if (this.href != null) {
            buff.append(this.href);
        }
        return buff.toString();
    }
}

