/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.DriverMode;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeCapabilitiesFactory
implements ICapabilitiesFactory {
    @Override
    public DesiredCapabilities createCapabilities(DriverConfig webDriverConfig) {
        DesiredCapabilities capability = null;
        capability = DesiredCapabilities.chrome();
        capability.setBrowserName(DesiredCapabilities.chrome().getBrowserName());
        ChromeOptions options = new ChromeOptions();
        if (webDriverConfig.getUserAgentOverride() != null) {
            options.addArguments(new String[]{"--user-agent=" + webDriverConfig.getUserAgentOverride()});
        }
        capability.setCapability("goog:chromeOptions", (Object)options);
        if (webDriverConfig.isEnableJavascript()) {
            capability.setJavascriptEnabled(true);
        } else {
            capability.setJavascriptEnabled(false);
        }
        capability.setCapability("takesScreenshot", true);
        capability.setCapability("acceptSslCerts", true);
        if (webDriverConfig.getBrowserVersion() != null) {
            capability.setVersion(webDriverConfig.getBrowserVersion());
        }
        if (webDriverConfig.getWebPlatform() != null) {
            capability.setPlatform(webDriverConfig.getWebPlatform());
        }
        if (webDriverConfig.getProxyHost() != null) {
            Proxy proxy = webDriverConfig.getProxy();
            capability.setCapability("proxy", (Object)proxy);
        }
        if (webDriverConfig.getChromeBinPath() != null) {
            capability.setCapability("chrome.binary", webDriverConfig.getChromeBinPath());
        }
        if (webDriverConfig.getMode() == DriverMode.LOCAL) {
            // empty if block
        }
        return capability;
    }
}

