/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.AbstractWebDriverFactory;
import com.seleniumtests.browserfactory.ChromeCapabilitiesFactory;
import com.seleniumtests.browserfactory.IWebDriverFactory;
import com.seleniumtests.driver.DriverConfig;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

public class ChromeDriverFactory
extends AbstractWebDriverFactory
implements IWebDriverFactory {
    public ChromeDriverFactory(DriverConfig cfg) {
        super(cfg);
    }

    protected WebDriver createNativeDriver() {
        WebDriverManager.chromedriver().setup();
        return new ChromeDriver((Capabilities)new ChromeCapabilitiesFactory().createCapabilities(this.webDriverConfig));
    }

    @Override
    public WebDriver createWebDriver() throws IOException {
        DriverConfig cfg = this.getWebDriverConfig();
        this.driver = this.createNativeDriver();
        this.setImplicitWaitTimeout(cfg.getImplicitWaitTimeout());
        if (cfg.getPageLoadTimeout() >= 0) {
            this.setPageLoadTimeout(cfg.getPageLoadTimeout());
        }
        this.setWebDriver(this.driver);
        return this.driver;
    }

    protected void setPageLoadTimeout(long timeout) {
        try {
            this.driver.manage().timeouts().pageLoadTimeout(timeout, TimeUnit.SECONDS);
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            // empty catch block
        }
    }
}

