/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.browserfactory;

import com.seleniumtests.browserfactory.ICapabilitiesFactory;
import com.seleniumtests.driver.DriverConfig;
import com.seleniumtests.driver.DriverMode;
import com.seleniumtests.helper.FileUtility;
import com.seleniumtests.helper.OSUtility;
import com.seleniumtests.resources.WebDriverExternalResources;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.remote.DesiredCapabilities;

public class IECapabilitiesFactory
implements ICapabilitiesFactory {
    private void handleExtractResources() throws IOException {
        String dir = this.getClass().getResource("/").getPath();
        if (!new File(dir = FileUtility.decodePath(dir)).exists()) {
            FileUtility.extractJar(dir, WebDriverExternalResources.class);
        }
        if (!new File(dir + "\\IEDriverServer.exe").exists()) {
            if (OSUtility.getIEVersion() < 10) {
                FileUtility.copyFile(dir + "\\IEDriverServer_x64.exe", dir + "\\IEDriverServer.exe");
            } else {
                FileUtility.copyFile(dir + "\\IEDriverServer_Win32.exe", dir + "\\IEDriverServer.exe");
            }
        }
        System.setProperty("webdriver.ie.driver", dir + "\\IEDriverServer.exe");
        System.out.println(dir + "\\IEDriverServer.exe");
    }

    @Override
    public DesiredCapabilities createCapabilities(DriverConfig cfg) {
        if (cfg.getMode() == DriverMode.LOCAL) {
            // empty if block
        }
        DesiredCapabilities capability = DesiredCapabilities.internetExplorer();
        capability.setBrowserName(DesiredCapabilities.internetExplorer().getBrowserName());
        if (cfg.isEnableJavascript()) {
            capability.setJavascriptEnabled(true);
        } else {
            capability.setJavascriptEnabled(false);
        }
        capability.setCapability("takesScreenshot", true);
        capability.setCapability("acceptSslCerts", true);
        capability.setCapability("ignoreZoomSetting", true);
        if (cfg.getBrowserVersion() != null) {
            capability.setVersion(cfg.getBrowserVersion());
        }
        if (cfg.getWebPlatform() != null) {
            capability.setPlatform(cfg.getWebPlatform());
        }
        if (cfg.getProxyHost() != null) {
            Proxy proxy = cfg.getProxy();
            capability.setCapability("proxy", (Object)proxy);
        }
        capability.setCapability("ignoreProtectedModeSettings", true);
        return capability;
    }
}

