/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.core;

import com.seleniumtests.core.TestLogging;
import com.seleniumtests.webelements.HtmlElement;
import java.util.logging.Level;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;

public class CustomEventListener
extends AbstractWebDriverEventListener {
    boolean isJSErrorFound;

    private void logErrors(String url, LogEntries logEntries) {
        if (logEntries.getAll().size() == 0) {
            TestLogging.log("********* No Severe Error on Browser Console *********", true);
        } else {
            for (LogEntry logEntry : logEntries) {
                if (!logEntry.getLevel().equals(Level.SEVERE)) continue;
                TestLogging.log("URL: " + url);
                TestLogging.logWebStep("Time stamp: " + logEntry.getTimestamp() + ", Log level: " + logEntry.getLevel() + ", Log message: " + logEntry.getMessage(), true);
                this.isJSErrorFound = true;
            }
            assert (!this.isJSErrorFound);
        }
    }

    private void logErrors(String event, WebElement element, LogEntries logEntries) {
        if (logEntries.getAll().size() == 0) {
            TestLogging.log("********* No Severe Error on Browser Console *********", true);
        } else {
            for (LogEntry logEntry : logEntries) {
                if (!logEntry.getLevel().equals(Level.SEVERE)) continue;
                TestLogging.log("Sever Console Error on Browser " + event + " clicking element: " + ((HtmlElement)element).getBy());
                TestLogging.logWebStep("Time stamp: " + logEntry.getTimestamp() + ", Log level: " + logEntry.getLevel() + ", Log message: " + logEntry.getMessage(), true);
                this.isJSErrorFound = true;
            }
            assert (!this.isJSErrorFound);
        }
    }

    private LogEntries getBrowserLogs(WebDriver webDriver) {
        return webDriver.manage().logs().get("browser");
    }

    public void beforeNavigateTo(String url, WebDriver webDriver) {
        this.logErrors(url, this.getBrowserLogs(webDriver));
    }

    public void afterNavigateTo(String url, WebDriver webDriver) {
        this.logErrors(url, this.getBrowserLogs(webDriver));
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        this.logErrors("before", element, this.getBrowserLogs(driver));
    }

    public void afterClickOn(WebElement element, WebDriver driver) {
        this.logErrors("after", element, this.getBrowserLogs(driver));
    }
}

