/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.helper;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringUtility {
    public static String constructMethodSignature(Method method, Object[] parameters) {
        return method.getDeclaringClass().getCanonicalName() + "." + method.getName() + "(" + StringUtility.constructParameterString(parameters) + ")";
    }

    public static String constructParameterString(Object[] parameters) {
        StringBuffer sbParam = new StringBuffer();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) {
                    sbParam.append("null, ");
                    continue;
                }
                if (parameters[i] instanceof String) {
                    sbParam.append("\"").append(parameters[i]).append("\", ");
                    continue;
                }
                sbParam.append(parameters[i]).append(", ");
            }
        }
        if (sbParam.length() > 0) {
            sbParam.delete(sbParam.length() - 2, sbParam.length() - 1);
        }
        return sbParam.toString();
    }

    public static String md5(String str) {
        if (str == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return str;
        }
        byte[] byteArray = messageDigest.digest();
        return StringUtility.toHexString(byteArray);
    }

    public static String toHexString(byte[] byteArray) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                builder.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            builder.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return builder.toString();
    }
}

