/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.Config;
import com.seleniumtests.xmldog.Difference;
import com.seleniumtests.xmldog.DifferenceConstants;
import com.seleniumtests.xmldog.DifferenceListener;
import com.seleniumtests.xmldog.Differences;
import com.seleniumtests.xmldog.NodeResult;
import com.seleniumtests.xmldog.OrderedMap;
import com.seleniumtests.xmldog.StringUtil;
import com.seleniumtests.xmldog.XMLDogConstants;
import com.seleniumtests.xmldog.XMLUtil;
import com.seleniumtests.xmldog.XNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Comparator
implements XMLDogConstants {
    private Node _controlNode = null;
    private Node _testNode = null;
    private Config _config = null;
    private List _listeners = new ArrayList();
    private Set _elist = new HashSet();
    private boolean _ignoringWhitespace = true;
    private boolean _includeNodeValueInXPath = true;

    public Comparator() {
        this(null, null, new Config());
    }

    public Comparator(Node controlNode, Node testNode, Config config) {
        this._config = config;
        this._controlNode = controlNode;
        this._testNode = testNode;
        this._ignoringWhitespace = config.isIgnoringWhitespace();
        this._includeNodeValueInXPath = config.includesNodeValuesInXPath();
        this._listeners.clear();
        this._listeners.add(new Differences());
    }

    public void addDifferenceListener(DifferenceListener listener) {
        if (listener != null) {
            this._listeners.add(listener);
        }
    }

    public void overrideDifferenceListener(DifferenceListener listener) {
        if (listener != null) {
            this._listeners.clear();
            this._listeners.add(listener);
        }
    }

    private void notifyDifferenceListeners(int type, Node controlNode, Node testNode, String msg) {
        block4: {
            block5: {
                block3: {
                    if (type != 0) break block3;
                    for (int i = 0; i < this._listeners.size(); ++i) {
                        ((DifferenceListener)this._listeners.get(i)).identicalNodeFound(controlNode, testNode, msg);
                    }
                    break block4;
                }
                if (type != 1) break block5;
                for (int i = 0; i < this._listeners.size(); ++i) {
                    ((DifferenceListener)this._listeners.get(i)).similarNodeFound(controlNode, testNode, msg);
                }
                break block4;
            }
            if (type != 2) break block4;
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((DifferenceListener)this._listeners.get(i)).nodeNotFound(controlNode, testNode, msg);
            }
        }
    }

    public void setControlNode(Node controlNode) {
        if (controlNode == null) {
            throw new IllegalArgumentException("Cannot compare null node");
        }
        this._controlNode = controlNode;
    }

    public Node getControlNode() {
        return this._controlNode;
    }

    public void setTestNode(Node testNode) {
        if (testNode == null) {
            throw new IllegalArgumentException("Cannot compare null node");
        }
        this._testNode = testNode;
    }

    public Node getTestNode() {
        return this._testNode;
    }

    protected boolean isIgnoringWhitespace() {
        return this._config.isIgnoringWhitespace();
    }

    public Differences compare() {
        Comparator.log("IN comparator compare method");
        return this.compare(this.getControlNode(), this.getTestNode());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Differences compare(Node controlNode, Node testNode) {
        Differences differences = new Differences();
        Comparator.log("IN the compare(node, node) method");
        Object parent = null;
        XNode xControlNode = new XNode(controlNode, XMLUtil.generateXPath(controlNode, this._ignoringWhitespace, this._includeNodeValueInXPath, false));
        XNode xTestNode = new XNode(testNode, XMLUtil.generateXPath(testNode, this._ignoringWhitespace, this._includeNodeValueInXPath, false));
        xControlNode.setDepth(0);
        xTestNode.setDepth(0);
        NodeResult nodeResult = new NodeResult(xControlNode, xTestNode, differences);
        if (testNode.getNodeType() != 9) {
            nodeResult = this.compareSimilarNodes(xControlNode, xTestNode, new OrderedMap(3));
            differences.add(nodeResult);
            return differences;
        }
        Comparator.log("Test Node is Document Node");
        Element controlRoot = ((Document)controlNode).getDocumentElement();
        if (testNode.hasChildNodes()) {
            if (controlNode.hasChildNodes()) {
                differences.add(this.compareChildNodes(xControlNode, xTestNode));
                return differences;
            }
            if (!this._config.isCustomDifference()) {
                differences.add("/" + testNode.getNodeName() + " is entirely new document");
                return differences;
            }
            Difference diff = new Difference(DifferenceConstants.NEW_DOCUMENT, null, xTestNode);
            differences.add(diff);
            return differences;
        }
        if (!this._config.isCustomDifference()) {
            differences.add("/" + testNode.getNodeName() + " is an empty document");
            return differences;
        }
        Difference diff = new Difference(DifferenceConstants.EMPTY_DOCUMENT, xControlNode, xTestNode);
        differences.add(diff);
        return differences;
    }

    protected NodeResult compareSimilarNodes(XNode xControl, XNode xTest, OrderedMap nodeTracker) {
        Differences differences = new Differences();
        boolean noSimilarNodes = true;
        boolean unset = true;
        Node control = xControl.getNode();
        Node test = xTest.getNode();
        XNode xSimilarNode = null;
        String similarNodeXPath = null;
        NodeResult bestfitNodeResult = new NodeResult(xControl, xTest, differences);
        Node parent = control.getParentNode();
        Comparator.log("Parent XPath " + XMLUtil.generateXPath(xControl.getXPath()));
        if (parent != null) {
            List similarNodes = XMLUtil.getSimilarChildXNodes(parent, test, this.isIgnoringWhitespace());
            Object similarNode = null;
            NodeResult nr = null;
            if (similarNodes.size() > 0) {
                noSimilarNodes = false;
            }
            for (int i = 0; i < similarNodes.size(); ++i) {
                xSimilarNode = (XNode)similarNodes.get(i);
                similarNodeXPath = XMLUtil.generateXPath(xSimilarNode.getNode(), XMLUtil.generateXPath(xControl.getXPath()), this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                xSimilarNode.setXPath(similarNodeXPath);
                if (test.getNodeType() == 1) {
                    Comparator.log("compareSimilarNodes: Test node is ELEMENT type");
                    nr = this.compareElements(xSimilarNode, xTest);
                } else if (test.getNodeType() == 5) {
                    Comparator.log("compareSimilarNodes: Test node is Entity Reference type");
                } else if (test.getNodeType() == 3) {
                    Comparator.log("compareSimilarNodes: Test node is TEXT type");
                    if (StringUtil.isWhitespaceStr(test.getNodeValue()) && this.isIgnoringWhitespace()) {
                        Comparator.log("compareSimilarNodes: Ignoring WHITE space node");
                    } else {
                        nr = this.compareText(xSimilarNode, xTest);
                    }
                } else if (test.getNodeType() == 10) {
                    Comparator.log("compareSimilarNodes: Test node is DOCUMENT TYPE type");
                    nr = this.compareDocumentType(xSimilarNode, xTest);
                } else if (test.getNodeType() == 8) {
                    Comparator.log("compareSimilarNodes: Test node is COMMENT type");
                    nr = this.compareComments(xSimilarNode, xTest);
                } else if (test.getNodeType() == 4) {
                    Comparator.log("compareSimilarNodes: Test node is CDATA SECTION type");
                    nr = this.compareCDATA(xSimilarNode, xTest);
                }
                if (nr == null) continue;
                if (nr.isExactMatch() || nr.isUniqueAttrMatch()) {
                    bestfitNodeResult = nr;
                    Object ntObject = null;
                    boolean shouldBreak = false;
                    ntObject = nodeTracker.getElement(similarNode);
                    if (ntObject == null) {
                        shouldBreak = true;
                    } else {
                        if (ntObject instanceof List) {
                            List l = (List)ntObject;
                            for (int j = 0; j < l.size(); ++j) {
                                if (!((NodeResult)l.get(j)).isMatch()) continue;
                                shouldBreak = true;
                                break;
                            }
                        }
                        if (ntObject instanceof NodeResult && !((NodeResult)ntObject).isMatch()) {
                            shouldBreak = true;
                        }
                    }
                    if (!shouldBreak) continue;
                    break;
                }
                if (unset) {
                    bestfitNodeResult = nr;
                    unset = false;
                    continue;
                }
                if (nr.getDifferences().size() < bestfitNodeResult.getDifferences().size()) {
                    bestfitNodeResult = nr;
                    continue;
                }
                if (nr.getDifferences().size() != bestfitNodeResult.getDifferences().size() || nodeTracker.getElement(bestfitNodeResult.getControlNode().getNode()) == null) continue;
                bestfitNodeResult = nr;
            }
        }
        if (!(!noSimilarNodes || this.isIgnoringWhitespace() && XMLUtil.isWhitespaceTextNode(test))) {
            bestfitNodeResult.setControlNode(new XNode(null, null));
            if (!this._config.isCustomDifference()) {
                differences.add("Added Node: Test Node " + xTest.getXPath());
            } else {
                Difference diff = new Difference(DifferenceConstants.NODE_NOT_FOUND, xControl, xTest);
                differences.add(diff);
            }
        }
        Comparator.log("Start===================================================================");
        Comparator.log("compareSimilarNodes: BestFitNode is " + bestfitNodeResult.toString());
        Comparator.log("End===================================================================");
        return bestfitNodeResult;
    }

    protected NodeResult compareDocumentType(XNode xControl, XNode xTest) {
        Differences differences = new Differences();
        NodeResult nodeResult = new NodeResult(xControl, xTest, differences);
        boolean diffName = false;
        boolean diffPublicId = false;
        boolean diffSysId = false;
        DocumentType control = (DocumentType)xControl.getNode();
        DocumentType test = (DocumentType)xTest.getNode();
        diffName = XMLUtil.areNullorEqual(control.getPublicId(), test.getPublicId(), this._ignoringWhitespace, this._includeNodeValueInXPath);
        if (!(diffName && (diffSysId = XMLUtil.areNullorEqual(control.getSystemId(), test.getSystemId(), this._ignoringWhitespace, this._includeNodeValueInXPath)) && (diffPublicId = XMLUtil.areNullorEqual(control.getName(), test.getName(), this._ignoringWhitespace, this._includeNodeValueInXPath)))) {
            if (!this._config.isCustomDifference()) {
                differences.add("Different DocumentType Node: Current Node " + xTest.getXPath() + " --> Golden Node " + xControl.getXPath());
            } else {
                Difference diff = null;
                if (diffName) {
                    diff = new Difference(DifferenceConstants.DOCTYPE_NAME, xControl, xTest);
                } else if (diffSysId) {
                    diff = new Difference(DifferenceConstants.DOCTYPE_SYSTEM_ID, xControl, xTest);
                } else if (diffPublicId) {
                    diff = new Difference(DifferenceConstants.DOCTYPE_PUBLIC_ID, xControl, xTest);
                }
                differences.add(diff);
            }
        }
        return nodeResult;
    }

    protected NodeResult compareComments(XNode xControl, XNode xTest) {
        Comment test;
        Differences differences = new Differences();
        NodeResult nodeResult = new NodeResult(xControl, xTest, differences);
        Comment control = (Comment)xControl.getNode();
        if (!XMLUtil.nodesEqual(control, test = (Comment)xTest.getNode(), this.isIgnoringWhitespace())) {
            if (!this._config.isCustomDifference()) {
                differences.add("Different Comment Node: Current Node" + xTest.getXPath() + " --> Golden Node " + xControl.getXPath());
            } else {
                Difference diff = new Difference(DifferenceConstants.COMMENT_VALUE, xControl, xTest);
                differences.add(diff);
            }
        } else {
            nodeResult.setIfExactMatch(true);
        }
        return nodeResult;
    }

    protected NodeResult compareCDATA(XNode xControl, XNode xTest) {
        Differences differences = new Differences();
        CDATASection control = (CDATASection)xControl.getNode();
        CDATASection test = (CDATASection)xTest.getNode();
        NodeResult nodeResult = new NodeResult(xControl, xTest, differences);
        if (!XMLUtil.nodesEqual(control, test, this.isIgnoringWhitespace())) {
            if (!this._config.isCustomDifference()) {
                differences.add("Different CDATA Node : Current Node " + xTest.getXPath() + " --> Golden Node " + xControl.getXPath());
            } else {
                Difference diff = new Difference(DifferenceConstants.CDATA_VALUE, xControl, xTest);
                differences.add(diff);
            }
        } else {
            nodeResult.setIfExactMatch(true);
        }
        return nodeResult;
    }

    protected NodeResult compareEntityRefs(XNode xControl, XNode xTest) {
        Differences differences = new Differences();
        EntityReference control = (EntityReference)xControl.getNode();
        EntityReference test = (EntityReference)xTest.getNode();
        NodeResult nodeResult = new NodeResult(xControl, xTest, differences);
        if (!XMLUtil.nodesEqual(control, test, this.isIgnoringWhitespace())) {
            differences.add("Different Comment Node : Current Node " + xTest.getXPath() + " --> Golden Node " + xControl.getXPath());
        } else {
            nodeResult.setIfExactMatch(true);
        }
        return nodeResult;
    }

    protected NodeResult compareText(XNode xControl, XNode xTest) {
        Differences differences = new Differences();
        Text control = (Text)xControl.getNode();
        Text test = (Text)xTest.getNode();
        NodeResult nodeResult = new NodeResult(xControl, xTest, differences);
        if (!XMLUtil.nodesEqual(control, test, this.isIgnoringWhitespace())) {
            if (!this._config.isCustomDifference()) {
                differences.add("Different Text Node: Current Node " + xTest.getXPath() + " --> Golden Node " + xControl.getXPath());
            } else {
                Difference diff = new Difference(DifferenceConstants.TEXT_VALUE, xControl, xTest);
                differences.add(diff);
            }
        } else {
            nodeResult.setIfExactMatch(true);
        }
        return nodeResult;
    }

    protected NodeResult compareElements(XNode xControl, XNode xTest) {
        Differences differences = new Differences();
        Element control = (Element)xControl.getNode();
        Element test = (Element)xTest.getNode();
        NodeResult nodeResult = new NodeResult(xControl, xTest, differences);
        Comparator.log("Comparing Elements at Test " + xTest.getXPath() + " Control " + xControl.getXPath());
        String uniqueAttrName = (String)this._config.getUniqueAttributeMap().get(test.getTagName());
        if (uniqueAttrName != null && XMLUtil.nodesEqual(control, test, this.isIgnoringWhitespace()) && control.hasAttributes() && test.hasAttributes()) {
            String testAttrValue = test.getAttribute(uniqueAttrName);
            String controlAttrValue = control.getAttribute(uniqueAttrName);
            if (!testAttrValue.trim().equals("") && controlAttrValue.equals(testAttrValue)) {
                nodeResult.setUniqueAttrMatch(true);
                return nodeResult;
            }
        }
        this.reportMissingAttrs(xControl, xTest, differences);
        differences.add(this.compareChildNodes(xControl, xTest));
        if (differences.size() == 0) {
            Comparator.log(" Exact match for Test ELEMENT node " + XMLUtil.getNodeBasics(test) + " with control node " + XMLUtil.getNodeBasics(control));
            nodeResult.setIfExactMatch(true);
        }
        return nodeResult;
    }

    private Differences reportMissingAttrs(XNode xControl, XNode xTest, Differences differences) {
        boolean includedEmpty = false;
        boolean excludedEmpty = false;
        List excludedAttrs = null;
        List includedAttrs = null;
        Element control = (Element)xControl.getNode();
        Element test = (Element)xTest.getNode();
        String controlNodeXPath = xControl.getXPath();
        String testNodeXPath = xTest.getXPath();
        Comparator.log("Comparing Attributes for test " + testNodeXPath + " control " + controlNodeXPath);
        Element controlNode = (Element)control.cloneNode(true);
        Element testNode = (Element)test.cloneNode(true);
        excludedAttrs = (List)this._config.getExcludedAttributesMap().get(testNode.getTagName());
        includedAttrs = (List)this._config.getIncludedAttributesMap().get(testNode.getTagName());
        if (includedAttrs == null || includedAttrs.size() == 0) {
            includedEmpty = true;
        }
        if (excludedAttrs == null || excludedAttrs.size() == 0) {
            excludedEmpty = true;
        }
        NamedNodeMap testAttrs = testNode.getAttributes();
        NamedNodeMap controlAttrs = controlNode.getAttributes();
        NamedNodeMap testAttrsForXPath = test.getAttributes();
        NamedNodeMap controlAttrsForXPath = control.getAttributes();
        if (!excludedEmpty) {
            for (int i = 0; i < excludedAttrs.size(); ++i) {
                if (testAttrs != null) {
                    testAttrs.removeNamedItem((String)excludedAttrs.get(i));
                }
                if (controlAttrs == null) continue;
                controlAttrs.removeNamedItem((String)excludedAttrs.get(i));
            }
        }
        String testAttrName = null;
        Attr testAttrNode = null;
        Attr testAttrNodeXPath = null;
        Attr controlAttrNode = null;
        Attr controlAttrNodeXPath = null;
        String controlAttrNodeXPathStr = null;
        if (testAttrs != null) {
            for (int j = 0; j < testAttrs.getLength(); ++j) {
                Difference diff;
                testAttrNode = (Attr)testAttrs.item(j);
                testAttrName = testAttrNode.getName();
                testAttrNodeXPath = (Attr)testAttrsForXPath.getNamedItem(testAttrName);
                if (!includedEmpty && !includedAttrs.contains(testAttrName)) continue;
                String nodeXPath = XMLUtil.generateXPath(testAttrNode, testNodeXPath, this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                if (this._config.isXPathEListEnabled()) {
                    if (this._config.applyEListToSiblings()) {
                        nodeXPath = XMLUtil.getNoIndexXPath(nodeXPath);
                    }
                    if (this._config.getXPathEList().containsKey(nodeXPath)) continue;
                }
                if (controlAttrs != null) {
                    controlAttrNode = (Attr)controlAttrs.getNamedItem(testAttrName);
                    controlAttrNodeXPath = (Attr)controlAttrsForXPath.getNamedItem(testAttrName);
                }
                XNode xTestNode = null;
                XNode xControlNode = null;
                if (controlAttrNode == null) {
                    Comparator.log("Added Attribute: Test node " + nodeXPath);
                    if (!this._config.isCustomDifference()) {
                        differences.add("New Attribute added: Test Node " + nodeXPath);
                        continue;
                    }
                    if (testAttrNode != null) {
                        xTestNode = new XNode(testAttrNodeXPath, XMLUtil.generateXPath(testAttrNode, testNodeXPath, this._ignoringWhitespace, this._includeNodeValueInXPath, false));
                    }
                    if (controlAttrNode != null) {
                        xControlNode = new XNode(controlAttrNodeXPath, XMLUtil.generateXPath(controlAttrNode, controlNodeXPath, this._ignoringWhitespace, this._includeNodeValueInXPath, false));
                    }
                    diff = new Difference(DifferenceConstants.ATTR_NAME_NOT_FOUND, xControlNode, xTestNode);
                    differences.add(diff);
                    continue;
                }
                if (!controlAttrNode.getValue().equals(testAttrNode.getValue())) {
                    controlAttrNodeXPathStr = XMLUtil.generateXPath(controlAttrNode, controlNodeXPath, this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                    Comparator.log("Different Attributes: Test document Node " + nodeXPath + " --> Control document Node " + controlAttrNodeXPathStr);
                    if (!this._config.isCustomDifference()) {
                        differences.add("Different Attributes: Current Node " + nodeXPath + " --> Golden Node " + controlAttrNodeXPathStr);
                    } else {
                        if (testAttrNode != null) {
                            xTestNode = new XNode(testAttrNode, XMLUtil.generateXPath(testAttrNode, testNodeXPath, this._ignoringWhitespace, this._includeNodeValueInXPath, false));
                        }
                        if (controlAttrNode != null) {
                            xControlNode = new XNode(controlAttrNode, controlAttrNodeXPathStr);
                        }
                        diff = new Difference(DifferenceConstants.ATTR_VALUE, xControlNode, xTestNode);
                        differences.add(diff);
                    }
                }
                controlAttrs.removeNamedItem(testAttrName);
            }
        }
        if (controlAttrs.getLength() > 0) {
            XNode xTestNode = null;
            XNode xControlNode = null;
            for (int i = 0; i < controlAttrs.getLength(); ++i) {
                controlAttrNode = (Attr)controlAttrs.item(i);
                controlAttrNodeXPath = (Attr)controlAttrsForXPath.getNamedItem(controlAttrNode.getName());
                testAttrNodeXPath = (Attr)testAttrsForXPath.getNamedItem(controlAttrNode.getName());
                controlAttrNodeXPathStr = XMLUtil.generateXPath(controlAttrNodeXPath, controlNodeXPath, this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                if (this._config.isXPathEListEnabled()) {
                    if (this._config.applyEListToSiblings()) {
                        controlAttrNodeXPathStr = XMLUtil.getNoIndexXPath(controlAttrNodeXPathStr);
                    }
                    if (this._config.getXPathEList().containsKey(controlAttrNodeXPathStr)) continue;
                }
                Comparator.log("Missing Attribute: Test document is missing attribute " + XMLUtil.generateXPath(controlAttrNodeXPath, this.isIgnoringWhitespace()));
                if (!this._config.isCustomDifference()) {
                    differences.add("Missing Attribute: Test Node " + controlAttrNodeXPathStr);
                    continue;
                }
                if (testAttrNodeXPath != null) {
                    xTestNode = new XNode(testAttrNodeXPath, XMLUtil.generateXPath(testAttrNodeXPath, testNodeXPath, this._ignoringWhitespace, this._includeNodeValueInXPath, false));
                }
                if (controlAttrNodeXPath != null) {
                    xControlNode = new XNode(controlAttrNodeXPath, controlAttrNodeXPathStr);
                }
                Difference diff = new Difference(DifferenceConstants.ATTR_NAME_NOT_FOUND, xControlNode, xTestNode);
                differences.add(diff);
            }
        }
        return differences;
    }

    protected NodeResult compareAttributes(XNode xControl, XNode xTest) {
        Differences differences = new Differences();
        NodeResult nodeResult = new NodeResult(xControl, xTest, differences);
        return nodeResult;
    }

    protected Differences compareChildNodes(XNode xControl, XNode xTest) {
        Differences differences;
        block38: {
            Node controlChildNode;
            NodeList controlChildNodes;
            Node control;
            block37: {
                if (xControl == null || xTest == null) {
                    throw new IllegalArgumentException("Test and/or Control Node argument cannot be null");
                }
                Comparator.log("Comparing CHILD Nodes for Test:" + xTest.getXPath() + "-Control:" + xControl.getXPath() + "-");
                differences = new Differences();
                OrderedMap nodeTracker = new OrderedMap(3);
                control = xControl.getNode();
                Node test = xTest.getNode();
                NodeList testChildNodes = null;
                controlChildNodes = null;
                Node testChildNode = null;
                controlChildNode = null;
                if (control == null) {
                    if (test != null) {
                        if (!this._config.isCustomDifference()) {
                            differences.add("Test Node added at " + xTest.getXPath());
                        } else {
                            Difference diff = new Difference(DifferenceConstants.ADDED_NODE, null, xTest);
                            differences.add(diff);
                        }
                        return differences;
                    }
                    return null;
                }
                if (test == null) {
                    if (!this._config.isCustomDifference()) {
                        differences.add("Golden Node added at " + xControl.getXPath());
                    } else {
                        Difference diff = new Difference(DifferenceConstants.ADDED_NODE, xControl, null);
                        differences.add(diff);
                    }
                    return differences;
                }
                if (!test.hasChildNodes()) break block37;
                if (control.hasChildNodes()) {
                    testChildNodes = test.getChildNodes();
                    controlChildNodes = control.getChildNodes();
                    NodeResult matchedNodeResult = null;
                    String testNodeXPath = null;
                    XNode xControlChildNode = null;
                    XNode xTestChildNode = null;
                    String testChildXPath = null;
                    String controlChildXPath = null;
                    for (int i = 0; i < testChildNodes.getLength(); ++i) {
                        testChildNode = testChildNodes.item(i);
                        testChildXPath = XMLUtil.generateXPath(testChildNode, xTest.getXPath(), this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                        xTestChildNode = new XNode(testChildNode, testChildXPath);
                        xTestChildNode.setDepth(xTest.getDepth() + 1);
                        xTestChildNode.setPosition(i);
                        controlChildNode = controlChildNodes.item(i) == null ? controlChildNodes.item(0) : controlChildNodes.item(i);
                        Comparator.log("******** controlChildNode " + controlChildNode.getNodeName() + " type " + controlChildNode.getNodeType());
                        controlChildXPath = XMLUtil.generateXPath(controlChildNode, xControl.getXPath(), this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                        Comparator.log("compareChildNodes()......controlChildXPath " + controlChildXPath);
                        xControlChildNode = new XNode(controlChildNode, controlChildXPath);
                        if (this._config.isXPathEListEnabled()) {
                            String string = testNodeXPath = this._config.applyEListToSiblings() ? xTestChildNode.getNoIndexXPath() : xTestChildNode.getXPath();
                        }
                        if (XMLUtil.isWhitespaceTextNode(testChildNode) && this.isIgnoringWhitespace()) {
                            Comparator.log("Ignoring Whitespace Node");
                            continue;
                        }
                        if (XMLUtil.isCommentNode(testChildNode) && this._config.isIgnoringComments()) {
                            Comparator.log("Ignoring Comment Node");
                            continue;
                        }
                        if (testNodeXPath != null && this._config.getXPathEList().containsKey(testNodeXPath)) {
                            Comparator.log("Ignoring the Node since its XPath entry in EList file");
                            continue;
                        }
                        if (testChildNode.getNodeType() == 1 && this._config.getExcludedElementsSet().contains(testChildNode.getNodeName())) {
                            Comparator.log("compareChildNodes: Ignoring element child node at " + XMLUtil.generateXPath(testChildNode, this.isIgnoringWhitespace()) + " since its in ignore list");
                            continue;
                        }
                        matchedNodeResult = this.compareSimilarNodes(xControlChildNode, xTestChildNode, nodeTracker);
                        Comparator.log("CompareChildNodes: Matched node result " + matchedNodeResult.toString());
                        if (matchedNodeResult.getControlNode() != null) {
                            nodeTracker.add(matchedNodeResult.getControlNode().getNode(), matchedNodeResult);
                            continue;
                        }
                        differences.add(matchedNodeResult);
                    }
                    Object[] nodeResults = nodeTracker.elements();
                    for (int i = 0; i < nodeResults.length; ++i) {
                        Object nodeResult = nodeResults[i];
                        NodeResult minDiffNR = null;
                        if (nodeResult instanceof List) {
                            Comparator.log("CompareChildNodes: ++++++ Adding child differences from LIST NodeResult " + nodeResult.toString());
                            NodeResult currentNR = null;
                            minDiffNR = (NodeResult)((List)nodeResult).get(0);
                            for (int j = 1; j < ((List)nodeResult).size(); ++j) {
                                Difference diff;
                                XNode xCNode;
                                XNode xTNode;
                                currentNR = (NodeResult)((List)nodeResult).get(j);
                                if (currentNR.getNumDifferences() < minDiffNR.getNumDifferences()) {
                                    if (!this._config.isCustomDifference()) {
                                        if (currentNR.getNumDifferences() == 0) {
                                            differences.add("Added Node: Test Node " + minDiffNR.getTestNode().getXPath());
                                        } else {
                                            differences.add("Added Node/Multiple Matches: Current Node " + minDiffNR.getTestNode().getXPath() + " seems to match with already matched Golden Node at " + minDiffNR.getControlNode().getXPath());
                                            differences.add(minDiffNR);
                                        }
                                    } else {
                                        xTNode = new XNode(minDiffNR.getTestNode().getNode(), minDiffNR.getTestNode().getXPath());
                                        xCNode = new XNode(minDiffNR.getControlNode().getNode(), minDiffNR.getControlNode().getXPath());
                                        diff = null;
                                        diff = currentNR.getNumDifferences() == 0 ? new Difference(DifferenceConstants.ADDED_NODE, xCNode, xTNode) : new Difference(DifferenceConstants.MULTIPLE_MATCHES_ADDED_NODE, xCNode, xTNode);
                                        differences.add(diff);
                                    }
                                    minDiffNR = currentNR;
                                    continue;
                                }
                                if (!this._config.isCustomDifference()) {
                                    if (minDiffNR.getNumDifferences() == 0) {
                                        differences.add("Added Node: Test Node " + currentNR.getTestNode().getXPath());
                                        continue;
                                    }
                                    differences.add("Added Node/Multiple matches: Current Node " + currentNR.getTestNode().getXPath() + " seems to match with already matched Golden Node at " + currentNR.getControlNode().getXPath());
                                    differences.add(currentNR);
                                    continue;
                                }
                                xTNode = new XNode(currentNR.getTestNode().getNode(), currentNR.getTestNode().getXPath());
                                xCNode = new XNode(minDiffNR.getControlNode().getNode(), currentNR.getControlNode().getXPath());
                                diff = null;
                                diff = minDiffNR.getNumDifferences() == 0 ? new Difference(DifferenceConstants.ADDED_NODE, xCNode, xTNode) : new Difference(DifferenceConstants.MULTIPLE_MATCHES_ADDED_NODE, xCNode, xTNode);
                                differences.add(diff);
                            }
                            if (!this._config.isIgnoringOrder() && minDiffNR.getControlNode().getPosition() != minDiffNR.getTestNode().getPosition()) {
                                if (!this._config.isCustomDifference()) {
                                    differences.add("Position Mismatch: Current Node " + minDiffNR.getTestNode().getXPath() + " at position " + minDiffNR.getTestNode().getPosition() + " matches " + (minDiffNR.isExactMatch() ? "" : "closely") + " with Golden Node " + minDiffNR.getControlNode().getXPath() + " at position " + minDiffNR.getControlNode().getPosition());
                                } else {
                                    differences.add(new Difference(DifferenceConstants.POSITION_MISMATCH, minDiffNR.getControlNode(), minDiffNR.getTestNode()));
                                }
                            }
                            differences.add(minDiffNR);
                            continue;
                        }
                        NodeResult nr = (NodeResult)nodeResult;
                        Comparator.log("compareChildNodes: ++++++ Adding child differences from INDIVIDUAL NodeResult " + nodeResult.toString());
                        if (!this._config.isIgnoringOrder() && nr.getControlNode().getPosition() != nr.getTestNode().getPosition()) {
                            if (!this._config.isCustomDifference()) {
                                differences.add("Position Mismatch: Current Node " + nr.getTestNode().getXPath() + " at position " + nr.getTestNode().getPosition() + " matches " + (nr.isExactMatch() ? "" : "closely") + " with Golden Node " + nr.getControlNode().getXPath() + " at position " + nr.getControlNode().getPosition());
                            } else {
                                differences.add(new Difference(DifferenceConstants.POSITION_MISMATCH, nr.getControlNode(), nr.getTestNode()));
                            }
                        }
                        differences.add(nr);
                    }
                    String controlChildNodeXPathStr = null;
                    for (int i = 0; i < controlChildNodes.getLength(); ++i) {
                        controlChildNode = controlChildNodes.item(i);
                        controlChildNodeXPathStr = XMLUtil.generateXPath(controlChildNode, xControl.getXPath(), this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                        if (nodeTracker.containsElementKey(controlChildNode)) continue;
                        if (this._config.applyEListToSiblings()) {
                            controlChildNodeXPathStr = XMLUtil.getNoIndexXPath(controlChildNodeXPathStr);
                        }
                        if (this._config.getXPathEList().containsKey(controlChildNodeXPathStr)) continue;
                        this.reportNodeDifference(new XNode(controlChildNode, XMLUtil.generateXPath(controlChildNode, xControl.getXPath(), this._ignoringWhitespace, this._includeNodeValueInXPath, false)), xTest, differences, "Missing Node: Current Node ");
                    }
                } else {
                    testChildNodes = test.getChildNodes();
                    String testChildNodeXPathStr = null;
                    for (int i = 0; i < testChildNodes.getLength(); ++i) {
                        testChildNode = testChildNodes.item(i);
                        testChildNodeXPathStr = XMLUtil.generateXPath(testChildNode, xTest.getXPath(), this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                        this.reportNodeDifference(xControl, new XNode(testChildNode, testChildNodeXPathStr), differences, "Added Node: Test Node ");
                    }
                }
                break block38;
            }
            if (!control.hasChildNodes()) break block38;
            String controlChildNodeXPathStr = null;
            controlChildNodes = control.getChildNodes();
            for (int i = 0; i < controlChildNodes.getLength(); ++i) {
                controlChildNode = controlChildNodes.item(i);
                controlChildNodeXPathStr = XMLUtil.generateXPath(controlChildNode, xControl.getXPath(), this._ignoringWhitespace, this._includeNodeValueInXPath, false);
                this.reportNodeDifference(new XNode(controlChildNode, controlChildNodeXPathStr), xTest, differences, "Missing Node: Test document is missing node ");
            }
        }
        return differences;
    }

    private void reportNodeDifference(XNode xControl, XNode xTest, Differences differences, String msg) {
        XNode node;
        Node control = xControl.getNode();
        Node test = xTest.getNode();
        if (control == null && test == null) {
            return;
        }
        XNode xNode = node = control == null ? xTest : xControl;
        if (!(XMLUtil.isWhitespaceTextNode(node.getNode()) && this.isIgnoringWhitespace() || XMLUtil.isCommentNode(node.getNode()) && this._config.isIgnoringComments())) {
            if (node.getNode().getNodeType() == 1 && this._config.getExcludedElementsSet().contains(node.getNode().getNodeName())) {
                Comparator.log("Ignoring element child node at " + node.getXPath() + " since its in ignore list");
            } else if (!this._config.isCustomDifference()) {
                differences.add(msg + node.getXPath());
            } else {
                Object testNodeDetail = null;
                Object controlNodeDetail = null;
                Difference diff = new Difference(DifferenceConstants.NODE_NOT_FOUND, xControl, xTest);
                differences.add(diff);
            }
        }
    }

    public static void log(String msg) {
    }

    public static void log(String msg, Throwable t) {
    }
}

