/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumtests.xmldog;

import com.seleniumtests.xmldog.StringUtil;
import com.seleniumtests.xmldog.XMLDogConstants;
import com.seleniumtests.xmldog.XNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil
implements XMLDogConstants {
    private static DocumentBuilder _docBuilder = null;

    public static List getSimilarChildNodes(Node parent, Node testNode, boolean ignoreWhitespace) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (!parent.hasChildNodes()) {
            return nodes;
        }
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!XMLUtil.nodesSimilar(childNodes.item(i), testNode, ignoreWhitespace)) continue;
            nodes.add(childNodes.item(i));
        }
        return nodes;
    }

    public static List getSimilarChildXNodes(Node parent, Node testNode, boolean ignoreWhitespace) {
        ArrayList<XNode> nodes = new ArrayList<XNode>();
        if (!parent.hasChildNodes()) {
            return nodes;
        }
        NodeList childNodes = parent.getChildNodes();
        XNode xNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!XMLUtil.nodesSimilar(childNodes.item(i), testNode, ignoreWhitespace)) continue;
            xNode = new XNode(childNodes.item(i), null);
            xNode.setPosition(i);
            nodes.add(xNode);
        }
        return nodes;
    }

    public static String replaceElementText(String xmlFile, String tagName, String value, boolean all, boolean overwrite) throws DOMException {
        HashMap<String, String> elements = new HashMap<String, String>();
        elements.put(tagName, value);
        return XMLUtil.replaceElementText(xmlFile, elements, all, overwrite);
    }

    public static Document getDocument(String docPath) throws SAXException, IOException {
        return _docBuilder.parse(docPath);
    }

    public static String replaceElementText(String xmlFile, Map elements, boolean all, boolean overwrite) throws DOMException {
        if (xmlFile == null || elements == null) {
            return null;
        }
        File file = null;
        OutputStreamWriter fw = null;
        Document doc = null;
        try {
            doc = _docBuilder.parse(xmlFile);
            String xmlStr = XMLUtil.print(doc, false, false);
            Set allElements = elements.keySet();
            if (allElements.size() > 0) {
                for (String tagName : allElements) {
                    String value = (String)elements.get(tagName);
                    NodeList nodes = doc.getDocumentElement().getElementsByTagName(tagName);
                    if (value == null) continue;
                    for (int i = 0; i < nodes.getLength() && (all || i <= 0); ++i) {
                        Node element = nodes.item(i);
                        String eText = XMLUtil.getText(element);
                        element = XMLUtil.removeChildren(element);
                        Text textNode = doc.createTextNode(value);
                        element.appendChild(textNode);
                    }
                }
                String newXMLStr = XMLUtil.print(doc, false, false);
                if (overwrite) {
                    file = new File(xmlFile);
                    file.renameTo(new File(xmlFile + ".bak"));
                    fw = new FileWriter(file);
                    fw.write(newXMLStr);
                    fw.flush();
                }
                String string = newXMLStr;
                return string;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new DOMException(13, "Error replacing Element text " + ex.toString());
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
            file = null;
            fw = null;
            doc = null;
        }
        return null;
    }

    public static String replaceElementText(String xmlFile, String elementTag, List values, boolean overwrite) throws DOMException {
        File file = null;
        OutputStreamWriter fw = null;
        Document doc = null;
        if (xmlFile == null || elementTag == null || elementTag.trim().equals("") || values == null) {
            return null;
        }
        try {
            doc = _docBuilder.parse(xmlFile);
            String xmlStr = XMLUtil.print(doc, false, false);
            NodeList nodes = doc.getDocumentElement().getElementsByTagName(elementTag);
            int limit = nodes.getLength() < values.size() ? nodes.getLength() : values.size();
            for (int i = 0; i < limit; ++i) {
                Node element = nodes.item(i);
                element = XMLUtil.removeChildren(element);
                Text textNode = doc.createTextNode((String)values.get(i));
                element.appendChild(textNode);
            }
            if (values.size() > nodes.getLength()) {
                Element parent = (Element)nodes.item(0).getParentNode();
                for (int i = nodes.getLength(); i < values.size(); ++i) {
                    if (values.get(i) == null || ((String)values.get(i)).trim().equals("")) continue;
                    Element newElement = doc.createElement(elementTag);
                    Text textNode = doc.createTextNode((String)values.get(i));
                    newElement.appendChild(textNode);
                    parent.appendChild(newElement);
                }
            }
            String newXMLStr = XMLUtil.print(doc, false, false);
            if (overwrite) {
                file = new File(xmlFile);
                file.renameTo(new File(xmlFile + ".bak"));
                fw = new FileWriter(file);
                fw.write(newXMLStr);
                fw.flush();
            }
            String string = newXMLStr;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DOMException(13, "Error replacing Element text " + ex.toString());
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
            file = null;
            fw = null;
            doc = null;
        }
    }

    public static Node removeChildren(Node node) {
        if (node.getNodeType() == 1) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                Node temp = node.removeChild(child);
                --i;
            }
        }
        return node;
    }

    public static String getText(Node node) {
        StringBuffer result = new StringBuffer();
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() == 4) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() != 5) continue;
            result.append(XMLUtil.getText(subnode));
        }
        return result.toString();
    }

    public static String print(Node node, boolean canonical, boolean normalize) {
        StringBuffer sb = new StringBuffer();
        if (node == null) {
            return null;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!canonical) {
                    String Encoding = "UTF-8";
                    sb.append("<?xml version=\"1.0\" encoding=\"" + Encoding + "\"?>");
                    sb.append(StringUtil.getNewlineStr());
                }
                XMLUtil.print(((Document)node).getDocumentElement(), canonical, normalize);
                NodeList children = node.getChildNodes();
                for (int iChild = 0; iChild < children.getLength(); ++iChild) {
                    sb.append(XMLUtil.print(children.item(iChild), canonical, normalize));
                }
                break;
            }
            case 1: {
                sb.append('<');
                sb.append(node.getNodeName());
                Attr[] attrs = XMLUtil.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    sb.append(' ');
                    sb.append(attr.getNodeName());
                    sb.append("=\"");
                    if (normalize) {
                        sb.append(XMLUtil.normalize(attr.getNodeValue(), canonical));
                    } else {
                        sb.append(attr.getNodeValue());
                    }
                    sb.append('\"');
                }
                sb.append('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    sb.append(XMLUtil.print(children.item(i), canonical, normalize));
                }
                break;
            }
            case 5: {
                if (canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        sb.append(XMLUtil.print(children.item(i), canonical, normalize));
                    }
                    break;
                }
                sb.append('&');
                System.out.println("Entity node name " + node.getNodeName());
                sb.append(node.getNodeName());
                sb.append(';');
                break;
            }
            case 4: {
                if (canonical) {
                    if (normalize) {
                        sb.append(XMLUtil.normalize(node.getNodeValue(), canonical));
                        break;
                    }
                    sb.append(node.getNodeValue());
                    break;
                }
                sb.append("<![CDATA[");
                sb.append(node.getNodeValue());
                sb.append("]]>");
                break;
            }
            case 3: {
                sb.append(XMLUtil.normalize(node.getNodeValue(), canonical));
                break;
            }
            case 7: {
                sb.append("<?");
                sb.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    sb.append(' ');
                    sb.append(data);
                }
                sb.append("?>");
                break;
            }
            case 10: {
                sb.append("<!DOCTYPE ");
                sb.append(node.getNodeName());
                sb.append(" PUBLIC ");
                sb.append("\"" + ((DocumentType)node).getPublicId() + "\" ");
                sb.append(" \"" + ((DocumentType)node).getSystemId() + "\"");
                sb.append(">");
                sb.append(StringUtil.getNewlineStr());
            }
        }
        if (type == 1) {
            sb.append("</");
            sb.append(node.getNodeName());
            sb.append('>');
        }
        return sb.toString();
    }

    protected static String normalize(String s, boolean canonical) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block8;
                }
                case '>': {
                    str.append("&gt;");
                    continue block8;
                }
                case '&': {
                    str.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (canonical) {
                        str.append("&#");
                        str.append(ch);
                        str.append(';');
                        continue block8;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    protected static Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    public static String generateXPath(String childXPath) {
        return childXPath.substring(0, childXPath.lastIndexOf("/"));
    }

    public static String generateXPath(Node node, boolean ignoreWhitespace) {
        return XMLUtil.generateXPath(node, ignoreWhitespace, false);
    }

    public static String generateXPath(Node node, boolean ignoreWhitespace, boolean noValues) {
        return XMLUtil.generateXPath(node, ignoreWhitespace, noValues, false);
    }

    public static String generateXPath(Node node, boolean ignoreWhitespace, boolean includeValues, boolean noIndex) {
        boolean noValues;
        boolean bl = noValues = !includeValues;
        if (node == null) {
            return "";
        }
        Node parent = node.getParentNode();
        int index = noIndex ? 0 : XMLUtil.getXPathNodeIndex(node, ignoreWhitespace);
        String indexStr = "";
        if (index > 0) {
            indexStr = "[" + index + "]";
        }
        if (node.getNodeType() == 9) {
            return "";
        }
        if (node.getNodeType() == 3) {
            return XMLUtil.generateXPath(parent, ignoreWhitespace, noValues, noIndex) + (noValues ? node.getNodeValue() + indexStr : "/TEXT(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 1) {
            return XMLUtil.generateXPath(parent, ignoreWhitespace, noValues, noIndex) + "/" + node.getNodeName() + indexStr;
        }
        if (node.getNodeType() == 8) {
            return XMLUtil.generateXPath(parent, ignoreWhitespace, noValues, noIndex) + (noValues ? node.getNodeValue() + indexStr : "/COMMENT(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 5) {
            return XMLUtil.generateXPath(parent, ignoreWhitespace, noValues, noIndex) + (noValues ? node.getNodeValue() + indexStr : "/EntityReference(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 7) {
            return XMLUtil.generateXPath(parent, ignoreWhitespace, noValues, noIndex) + (noValues ? node.getNodeValue() + indexStr : "/PI(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 2) {
            return XMLUtil.generateXPath(((Attr)node).getOwnerElement(), ignoreWhitespace, noValues, noIndex) + "/'@" + node.getNodeName() + (noValues ? "" : "=" + node.getNodeValue()) + "]";
        }
        if (node.getNodeType() == 10) {
            return XMLUtil.generateXPath(parent, ignoreWhitespace, noValues, noIndex) + (noValues ? node.getNodeValue() : "/DOCTYPE(" + node.getNodeName() + ")");
        }
        if (node.getNodeType() == 4) {
            return XMLUtil.generateXPath(parent, ignoreWhitespace, noValues, noIndex) + (noValues ? node.getNodeValue() : "/CDATA(" + node.getNodeName() + ")");
        }
        return "";
    }

    public static String generateXPath(Node node, String parentXPath, boolean ignoreWhitespace, boolean includeValues, boolean noIndex) {
        boolean noValues;
        boolean bl = noValues = !includeValues;
        if (node == null) {
            return "";
        }
        Node parent = node.getParentNode();
        int index = noIndex ? 0 : XMLUtil.getXPathNodeIndex(node, ignoreWhitespace);
        String indexStr = "";
        if (index > 0) {
            indexStr = "[" + index + "]";
        }
        if (node.getNodeType() == 9) {
            return parentXPath + "";
        }
        if (node.getNodeType() == 3) {
            return parentXPath + (noValues ? "/" + node.getNodeValue() + indexStr : "/TEXT(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 1) {
            return parentXPath + "/" + node.getNodeName() + indexStr;
        }
        if (node.getNodeType() == 8) {
            return parentXPath + (noValues ? "/" + node.getNodeValue() + indexStr : "/COMMENT(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 5) {
            return parentXPath + (noValues ? "/" + node.getNodeValue() + indexStr : "/EntityReference(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 7) {
            return parentXPath + (noValues ? "/" + node.getNodeValue() + indexStr : "/PI(" + node.getNodeValue() + ")" + indexStr);
        }
        if (node.getNodeType() == 2) {
            return parentXPath + "/[@" + node.getNodeName() + (noValues ? "" : "=" + node.getNodeValue()) + "]";
        }
        if (node.getNodeType() == 10) {
            return parentXPath + (noValues ? "/" + node.getNodeValue() : "/DOCTYPE(" + node.getNodeName() + ")");
        }
        if (node.getNodeType() == 4) {
            return parentXPath + (noValues ? "/" + node.getNodeValue() : "/CDATA(" + node.getNodeName() + ")");
        }
        return "";
    }

    public static String getNoIndexXPath(String xPath) {
        if (xPath == null) {
            return null;
        }
        boolean open = false;
        boolean closed = false;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < xPath.length(); ++i) {
            if (xPath.charAt(i) == '[') {
                open = true;
                closed = false;
                continue;
            }
            if (xPath.charAt(i) == ']' && open) {
                open = false;
                closed = true;
                continue;
            }
            if (open && !closed) continue;
            sb.append(xPath.charAt(i));
        }
        return sb.toString();
    }

    public static int getXPathNodeIndex(Node node, boolean ignoreWhitespace) {
        int nodeIndex = 0;
        if (node == null) {
            return -1;
        }
        Node prevNode = node;
        while ((prevNode = prevNode.getPreviousSibling()) != null) {
            if (!XMLUtil.nodesEqual(node, prevNode, ignoreWhitespace)) continue;
            ++nodeIndex;
        }
        if (nodeIndex > 0) {
            ++nodeIndex;
        }
        if (nodeIndex == 0) {
            Node nextNode = node;
            boolean found = false;
            while ((nextNode = nextNode.getNextSibling()) != null && !found) {
                if (!XMLUtil.nodesEqual(node, nextNode, ignoreWhitespace)) continue;
                ++nodeIndex;
                found = true;
            }
        }
        return nodeIndex;
    }

    public static boolean nodesEqual(Node node1, Node node2, boolean ignoreWhitespace) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (XMLUtil.areNonNullAndEqual(node1.getNamespaceURI(), node2.getNamespaceURI())) {
            return node1.getNodeType() == node2.getNodeType() && XMLUtil.areNullorEqual(node1.getNodeValue(), node2.getNodeValue(), ignoreWhitespace, false) && XMLUtil.areNullorEqual(node1.getLocalName(), node2.getLocalName(), ignoreWhitespace, false);
        }
        if (node1.getNamespaceURI() == null && node2.getNamespaceURI() == null) {
            return node1.getNodeType() == node2.getNodeType() && XMLUtil.areNullorEqual(node1.getNodeValue(), node2.getNodeValue(), ignoreWhitespace, false) && XMLUtil.areNullorEqual(node1.getNodeName(), node2.getNodeName(), ignoreWhitespace, false);
        }
        return false;
    }

    public static boolean nodesSimilar(Node node1, Node node2, boolean ignoreWhitespace) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (XMLUtil.areNonNullAndEqual(node1.getNamespaceURI(), node2.getNamespaceURI())) {
            return node1.getNodeType() == node2.getNodeType() && XMLUtil.areNullorEqual(node1.getLocalName(), node2.getLocalName(), ignoreWhitespace, false);
        }
        if (node1.getNamespaceURI() == null && node2.getNamespaceURI() == null) {
            return node1.getNodeType() == node2.getNodeType() && XMLUtil.areNullorEqual(node1.getNodeName(), node2.getNodeName(), ignoreWhitespace, false);
        }
        return false;
    }

    public static void printNodeBasics(Node node) {
        if (node == null) {
            System.out.println(" Null node");
            return;
        }
        System.out.println(" Node[Namespace URI=" + node.getNamespaceURI() + " localname=" + node.getLocalName() + " name=" + node.getNodeName() + " type=" + XMLUtil.getNodeTypeStr(node.getNodeType()) + " Value=" + node.getNodeValue() + "]");
    }

    public static String getNodeBasics(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node == null) {
            sb.append(" Null node");
            return sb.toString();
        }
        sb.append(" Node[Namespace URI=" + node.getNamespaceURI() + " localname=" + node.getLocalName() + " name=" + node.getNodeName() + " type=" + XMLUtil.getNodeTypeStr(node.getNodeType()) + " Value=" + node.getNodeValue() + "]");
        return sb.toString();
    }

    public static void removeLeafNode(Node node) {
        if (!node.hasChildNodes()) {
            node.getParentNode().removeChild(node);
        }
    }

    public static String getNodeTypeStr(int nodeType) {
        switch (nodeType) {
            case 2: {
                return "ATTRIBUTE_NODE ";
            }
            case 4: {
                return "CDATA_SECTION_NODE";
            }
            case 8: {
                return "COMMENT_NODE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT_NODE";
            }
            case 10: {
                return "DOCUMENT_TYPE_NODE";
            }
            case 1: {
                return "ELEMENT_NODE";
            }
            case 6: {
                return "ENTITY_NODE";
            }
            case 5: {
                return "ENTITY_REFERENCE_NODE";
            }
            case 12: {
                return "NOTATION_NODE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_NODE";
            }
            case 3: {
                return "TEXT_NODE";
            }
            case 9: {
                return "DOCUMENT_NODE";
            }
        }
        return "UN-INDENTIFIED NODE";
    }

    public static boolean isWhitespaceTextNode(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() == 3) {
            return StringUtil.isWhitespaceStr(node.getNodeValue());
        }
        return false;
    }

    public static boolean isCommentNode(Node node) {
        if (node == null) {
            return false;
        }
        return node.getNodeType() == 8;
    }

    public static boolean isStrElementNode(String elementName, Node elementNode, boolean ignoreCase) {
        if (elementNode == null || elementName == null || elementName.trim().equals("") || elementNode.getNodeType() != 1) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(":");
        int numTokens = tokenizer.countTokens();
        if (numTokens == 1) {
            String name = (String)tokenizer.nextElement();
            Element element = (Element)elementNode;
            if (element.getNamespaceURI() != null) {
                return false;
            }
            if (ignoreCase) {
                return element.getNodeName().trim().equalsIgnoreCase(elementName);
            }
            return element.getNodeName().trim().equals(elementName);
        }
        if (numTokens == 2) {
            String namespace = (String)tokenizer.nextElement();
            String localName = (String)tokenizer.nextElement();
            Element element = (Element)elementNode;
            if (element.getNamespaceURI() == null) {
                return false;
            }
            if (ignoreCase) {
                return element.getLocalName().trim().equalsIgnoreCase(localName) && element.getNamespaceURI().equalsIgnoreCase(namespace.trim());
            }
            return element.getLocalName().trim().equals(localName) && element.getNamespaceURI().equals(namespace.trim());
        }
        return false;
    }

    public static boolean areNullorEqual(Object obj1, Object obj2, boolean ignoreWhitespace, boolean ignoreCase) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof String && obj2 instanceof String) {
            if (ignoreWhitespace) {
                if (ignoreCase) {
                    return ((String)obj1).trim().equalsIgnoreCase(((String)obj2).trim());
                }
                return ((String)obj1).trim().equals(((String)obj2).trim());
            }
            if (ignoreCase) {
                return ((String)obj1).equalsIgnoreCase((String)obj2);
            }
            return obj1.equals(obj2);
        }
        return obj1.equals(obj2);
    }

    public static boolean areNonNullAndEqual(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static void log(String msg) {
    }

    public static void log(String msg, Throwable t) {
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("env-entry-type", "DONTCARE");
        ArrayList<String> values = new ArrayList<String>(3);
        values.add("111111");
        values.add("222222");
        System.out.println("Entity Ref node type 5");
        try {
            Document doc = XMLUtil.getDocument("d:\\try\\xml\\0095_a.xml");
            NodeList ens = doc.getElementsByTagName("Environment");
            Element env = (Element)ens.item(0);
            Attr expireAttr = env.getAttributeNode("expires");
            System.out.println("# of environment elements " + ens.getLength());
            System.out.println(" Expire attrs XPath " + XMLUtil.generateXPath(expireAttr, true, true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            _docBuilder = factory.newDocumentBuilder();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
            System.out.println("System id is " + systemID);
            if (systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd")) {
                return new InputSource("web-app_2_2.dtd");
            }
            if (systemID.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                return new InputSource("web-app_2_3.dtd");
            }
            return null;
        }
    }
}

