/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.response;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.shift4.enums.SubscriptionStatus;
import com.shift4.response.Billing;
import com.shift4.response.Charge;
import com.shift4.response.Shipping;
import com.shift4.response.ThreeDSecureInfo;
import com.shift4.util.Shift4Utils;
import java.util.HashMap;
import java.util.Map;

public class Subscription {
    private String id;
    private Long created;
    private boolean deleted = false;
    private String planId;
    private String customerId;
    private Integer quantity;
    private Boolean captureCharges;
    private String status;
    private Integer remainingBillingCycles;
    private Long start;
    private Long currentPeriodStart;
    private Long currentPeriodEnd;
    private Long canceledAt;
    private Long endedAt;
    private Long trialStart;
    private Long trialEnd;
    private Boolean cancelAtPeriodEnd;
    private Shipping shipping;
    private Billing billing;
    private ThreeDSecureInfo threeDSecureInfo;
    private Charge.FromCrossSale fromCrossSale;
    private String merchantAccountId;
    private Map<String, String> metadata;
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public Long getCreated() {
        return this.created;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Boolean getCaptureCharges() {
        return this.captureCharges;
    }

    public SubscriptionStatus getStatus() {
        return SubscriptionStatus.fromValue(this.status);
    }

    public String getStatusAsString() {
        return this.status;
    }

    public Integer getRemainingBillingCycles() {
        return this.remainingBillingCycles;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    public Long getCanceledAt() {
        return this.canceledAt;
    }

    public Long getEndedAt() {
        return this.endedAt;
    }

    public Long getTrialStart() {
        return this.trialStart;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    public Shipping getShipping() {
        return this.shipping;
    }

    public Billing getBilling() {
        return this.billing;
    }

    public ThreeDSecureInfo getThreeDSecureInfo() {
        return this.threeDSecureInfo;
    }

    public Charge.FromCrossSale getFromCrossSale() {
        return this.fromCrossSale;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String get(String name) {
        if ("merchantAccountId".equals(name)) {
            return this.merchantAccountId;
        }
        return Shift4Utils.toStringNullSafe(this.other.get(name));
    }

    @JsonAnySetter
    private void set(String name, Object value) {
        this.other.put(name, value);
    }
}

