/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.EventResponse;
import com.siftscience.FieldSet;
import com.siftscience.SiftRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class EventRequest
extends SiftRequest<EventResponse> {
    private List<String> abuseTypes = null;
    private boolean isWorkflowStatus = false;

    EventRequest(HttpUrl baseUrl, OkHttpClient okClient, FieldSet fields) {
        super(baseUrl, okClient, fields);
    }

    @Override
    EventResponse buildResponse(Response response, FieldSet requestFields) throws IOException {
        return new EventResponse(response, requestFields);
    }

    @Override
    protected HttpUrl path(HttpUrl baseUrl) {
        HttpUrl.Builder builder = baseUrl.newBuilder().addPathSegment("v205").addPathSegment("events");
        if (this.isWorkflowStatus) {
            builder.addQueryParameter("return_workflow_status", "true");
        } else if (this.abuseTypes != null) {
            builder.addQueryParameter("return_score", "true");
        }
        if (this.abuseTypes != null && this.abuseTypes.size() > 0) {
            String queryParamVal = "";
            for (String abuseType : this.abuseTypes) {
                queryParamVal = queryParamVal + abuseType + ",";
            }
            builder.addQueryParameter("abuse_types", queryParamVal.substring(0, queryParamVal.length() - 1));
        }
        return builder.build();
    }

    public EventRequest withScores(String ... abuseTypes) {
        this.abuseTypes = Arrays.asList(abuseTypes);
        return this;
    }

    public EventRequest withWorkflowStatus() {
        this.isWorkflowStatus = true;
        return this;
    }
}

