/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.FieldSet;
import com.siftscience.ScoreResponse;
import com.siftscience.SiftRequest;
import com.siftscience.model.ScoreFieldSet;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ScoreRequest
extends SiftRequest<ScoreResponse> {
    ScoreRequest(HttpUrl baseUrl, OkHttpClient okClient, ScoreFieldSet fields) {
        super(baseUrl, okClient, fields);
    }

    @Override
    protected void modifyRequestBuilder(Request.Builder builder) {
        builder.get();
    }

    @Override
    ScoreResponse buildResponse(Response response, FieldSet requestFields) throws IOException {
        return new ScoreResponse(response, requestFields);
    }

    @Override
    protected HttpUrl path(HttpUrl baseUrl) {
        ScoreFieldSet scoreFieldSet = (ScoreFieldSet)this.fieldSet;
        HttpUrl.Builder builder = baseUrl.newBuilder().addPathSegment("v205");
        builder.addPathSegment("score").addPathSegment(scoreFieldSet.getUserId()).addQueryParameter("api_key", scoreFieldSet.getApiKey());
        if (scoreFieldSet.getAbuseTypes() != null && scoreFieldSet.getAbuseTypes().size() > 0) {
            String queryParamVal = "";
            for (String abuseType : scoreFieldSet.getAbuseTypes()) {
                queryParamVal = queryParamVal + abuseType + ",";
            }
            builder.addQueryParameter("abuse_types", queryParamVal.substring(0, queryParamVal.length() - 1));
        }
        return builder.build();
    }
}

