/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.lang;

import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.lang.ReferenceCountingBase;
import com.simiacryptus.ref.wrappers.RefConsumer;
import com.simiacryptus.ref.wrappers.RefFunction;
import com.simiacryptus.ref.wrappers.RefHashSet;
import com.simiacryptus.ref.wrappers.RefLinkedBlockingQueue;
import com.simiacryptus.ref.wrappers.RefThreadLocal;
import com.simiacryptus.util.Util;
import javax.annotation.Nonnull;

public abstract class ResourcePool<T>
extends ReferenceCountingBase {
    private final @Nonnull RefHashSet<T> all;
    private final RefThreadLocal<T> currentValue = new RefThreadLocal();
    private final int maxItems;
    private final RefLinkedBlockingQueue<T> pool = new RefLinkedBlockingQueue();

    public ResourcePool(int maxItems) {
        this.maxItems = maxItems;
        RefHashSet temp_01_0001 = new RefHashSet(this.maxItems);
        this.all = temp_01_0001.addRef();
        temp_01_0001.freeRef();
    }

    public abstract T create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        this.assertAlive();
        RefHashSet<T> poll = this.pool.poll();
        if (null != poll) {
            RefUtil.assertAlive((Object)poll);
            return (T)poll;
        }
        poll = this.all;
        synchronized (poll) {
            if (this.all.size() < this.maxItems) {
                T poll2 = this.create();
                RefUtil.assertAlive(poll2);
                this.all.add(RefUtil.addRef(poll2));
                return poll2;
            }
        }
        try {
            Object take = this.pool.take();
            RefUtil.assertAlive((Object)take);
            return (T)take;
        }
        catch (InterruptedException e) {
            throw Util.throwException(e);
        }
    }

    public int size() {
        return this.all.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> @Nonnull U apply(@RefAware @Nonnull RefFunction<T, U> fn) {
        this.assertAlive();
        Object prior = this.currentValue.get();
        try {
            Object object;
            if (null != prior) {
                RefUtil.assertAlive((Object)prior);
                Object object2 = fn.apply(prior);
                return (U)object2;
            }
            T poll = this.get();
            RefUtil.assertAlive(poll);
            try {
                this.currentValue.set(RefUtil.addRef(poll));
                object = fn.apply(RefUtil.addRef(poll));
            }
            catch (Throwable throwable) {
                RefUtil.assertAlive(poll);
                this.pool.add(poll);
                this.currentValue.remove();
                throw throwable;
            }
            RefUtil.assertAlive(poll);
            this.pool.add(poll);
            this.currentValue.remove();
            return (U)object;
        }
        finally {
            RefUtil.freeRef(fn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(@RefAware @Nonnull RefConsumer<T> f) {
        block9: {
            assert (this.assertAlive());
            assert (this.pool.assertAlive());
            Object prior = this.currentValue.get();
            try {
                if (null != prior) {
                    f.accept(prior);
                    break block9;
                }
                T poll = this.get();
                try {
                    this.currentValue.set(RefUtil.addRef(poll));
                    f.accept(RefUtil.addRef(poll));
                }
                finally {
                    RefUtil.assertAlive(poll);
                    this.pool.add(poll);
                    this.currentValue.remove();
                }
            }
            finally {
                RefUtil.freeRef(f);
            }
        }
    }

    public void _free() {
        super._free();
        this.all.freeRef();
        this.pool.freeRef();
        this.currentValue.freeRef();
    }

    public @Nonnull ResourcePool<T> addRef() {
        return (ResourcePool)super.addRef();
    }
}

