/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.lang;

import com.simiacryptus.ref.lang.ReferenceCountingBase;
import com.simiacryptus.ref.wrappers.RefArrayList;
import com.simiacryptus.ref.wrappers.RefCollections;
import com.simiacryptus.ref.wrappers.RefConsumer;
import com.simiacryptus.ref.wrappers.RefLinkedBlockingQueue;
import com.simiacryptus.ref.wrappers.RefList;
import com.simiacryptus.util.Util;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class StaticResourcePool<T>
extends ReferenceCountingBase {
    private final @Nonnull RefList<T> all;
    private final RefLinkedBlockingQueue<T> pool = new RefLinkedBlockingQueue();

    public StaticResourcePool(@Nonnull RefList<T> items) {
        RefList temp_03_0001 = RefCollections.unmodifiableList((RefList)new RefArrayList((Collection)items.addRef()));
        this.all = temp_03_0001.addRef();
        temp_03_0001.freeRef();
        items.freeRef();
        this.pool.addAll(this.getAll());
    }

    public @Nonnull RefList<T> getAll() {
        return this.all.addRef();
    }

    public void apply(@Nonnull RefConsumer<T> f) {
        this.apply(f, x -> true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(@Nonnull RefConsumer<T> f, @Nonnull Predicate<T> filter, boolean exclusive) {
        T poll = this.get(filter, exclusive);
        try {
            f.accept(poll);
        }
        finally {
            this.pool.add(poll);
        }
    }

    public <U> U run(@Nonnull Function<T, U> f) {
        return this.run(f, x -> true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U run(@Nonnull Function<T, U> f, @Nonnull Predicate<T> filter, boolean exclusive) {
        if (this.all.isEmpty()) {
            throw new IllegalStateException();
        }
        T poll = this.get(filter, exclusive);
        try {
            U u = f.apply(poll);
            return u;
        }
        finally {
            this.pool.add(poll);
        }
    }

    public int size() {
        RefList<T> temp_03_0004 = this.getAll();
        int temp_03_0003 = temp_03_0004.size();
        temp_03_0004.freeRef();
        return temp_03_0003;
    }

    public void _free() {
        super._free();
        this.all.freeRef();
        this.pool.freeRef();
    }

    public @Nonnull StaticResourcePool<T> addRef() {
        return (StaticResourcePool)super.addRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nonnull T get(@Nonnull Predicate<T> filter, boolean exclusive) {
        Object poll;
        RefArrayList sampled = new RefArrayList();
        try {
            poll = this.pool.poll();
            while (null != poll) {
                if (filter.test(poll)) {
                    Object object = poll;
                    return (T)object;
                }
                sampled.add(poll);
                poll = this.pool.poll();
            }
        }
        finally {
            this.pool.addAll((Collection)sampled);
        }
        try {
            while (true) {
                if (null == (poll = this.pool.poll(5L, TimeUnit.MINUTES))) {
                    throw new RuntimeException("Timeout awaiting item from pool");
                }
                if (!exclusive || filter.test(poll)) break;
                this.pool.add(poll);
                Thread.sleep(0L);
            }
            return (T)poll;
        }
        catch (InterruptedException e) {
            throw Util.throwException(e);
        }
    }
}

